/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.ObjectChangeListener;
import javax.naming.ldap.HasControls;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeDecorator;
import org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.ldap.model.message.controls.EntryChange;
import org.apache.directory.shared.ldap.model.message.controls.PersistentSearch;
import org.apache.directory.shared.ldap.model.message.controls.PersistentSearchImpl;
import org.apache.directory.shared.ldap.util.JndiUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: cn=Tori Amos,ou=system", "objectClass: person", "objectClass: top", "cn: Tori Amos", "description: an American singer-songwriter", "sn: Amos"})
public class PersistentSearchIT
extends AbstractLdapTestUnit {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentSearchIT.class);
    private static final String BASE = "ou=system";
    private static final String PERSON_DESCRIPTION = "an American singer-songwriter";
    private static final String RDN = "cn=Tori Amos";
    EventDirContext ctx;
    EventService eventService;
    PSearchListener listener;
    Thread t;

    private Attributes getPersonAttributes(String sn, String cn) throws LdapException {
        Attributes attributes = LdifUtils.createJndiAttributes((Object[])new Object[]{"objectClass: top", "objectClass: person", "cn", cn, "sn", sn});
        return attributes;
    }

    private void setUpListenerReturnECs() throws Exception {
        this.setUpListener(true, (PersistentSearch)new PersistentSearchImpl(), false);
    }

    private void setUpListener(boolean returnECs, PersistentSearch persistentSearch, boolean ignoreEmptyRegistryCheck) throws Exception {
        this.ctx = (EventDirContext)ServerIntegrationUtils.getWiredContext((LdapServer)PersistentSearchIT.getLdapServer()).lookup(BASE);
        this.eventService = PersistentSearchIT.getLdapServer().getDirectoryService().getEventService();
        List registrationEntryList = this.eventService.getRegistrationEntries();
        if (!ignoreEmptyRegistryCheck) {
            Assert.assertTrue((boolean)registrationEntryList.isEmpty());
        }
        persistentSearch.setReturnECs(returnECs);
        this.listener = new PSearchListener(persistentSearch);
        this.t = new Thread((Runnable)this.listener, "PSearchListener");
        this.t.start();
        while (this.eventService.getRegistrationEntries().isEmpty()) {
            Thread.sleep(100L);
        }
        Thread.sleep(250L);
    }

    private void setUpListener() throws Exception {
        this.ctx = (EventDirContext)ServerIntegrationUtils.getWiredContext((LdapServer)PersistentSearchIT.getLdapServer()).lookup(BASE);
        this.eventService = PersistentSearchIT.getLdapServer().getDirectoryService().getEventService();
        List registrationEntryList = this.eventService.getRegistrationEntries();
        Assert.assertTrue((boolean)registrationEntryList.isEmpty());
        this.listener = new PSearchListener();
        this.t = new Thread((Runnable)this.listener, "PSearchListener");
        this.t.start();
        while (this.eventService.getRegistrationEntries().isEmpty()) {
            Thread.sleep(100L);
        }
        Thread.sleep(250L);
    }

    @After
    public void tearDownListener() throws Exception {
        this.listener.close();
        this.ctx.close();
        while (!this.eventService.getRegistrationEntries().isEmpty()) {
            Thread.sleep(100L);
        }
    }

    private void waitForThreadToDie(Thread t) throws Exception {
        long start = System.currentTimeMillis();
        while (t.isAlive()) {
            Thread.sleep(200L);
            if (System.currentTimeMillis() - start <= 1000L) continue;
            break;
        }
    }

    @Test
    public void testPsearchModify() throws Exception {
        this.setUpListener();
        this.ctx.modifyAttributes(RDN, 3, (Attributes)new BasicAttributes("description", PERSON_DESCRIPTION, true));
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)RDN, (Object)this.listener.result.getName());
    }

    @Test
    public void testPsearchModifyDn() throws Exception {
        this.setUpListener();
        this.ctx.rename(RDN, "cn=Jack Black");
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)"cn=Jack Black", (Object)this.listener.result.getName());
    }

    @Test
    public void testPsearchDelete() throws Exception {
        this.setUpListener();
        this.ctx.destroySubcontext(RDN);
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)RDN, (Object)this.listener.result.getName());
    }

    @Test
    public void testPsearchAdd() throws Exception {
        this.setUpListener();
        this.ctx.createSubcontext("cn=Jack Black", this.getPersonAttributes("Black", "Jack Black"));
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)"cn=Jack Black", (Object)this.listener.result.getName());
    }

    @Test
    public void testPsearchModifyWithEC() throws Exception {
        this.setUpListenerReturnECs();
        this.ctx.modifyAttributes(RDN, 3, (Attributes)new BasicAttributes("description", PERSON_DESCRIPTION, true));
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)RDN, (Object)this.listener.result.getName());
        Assert.assertEquals((Object)this.listener.result.control.getChangeType(), (Object)ChangeType.MODIFY);
    }

    @Test
    public void testPsearchModifyDnWithEC() throws Exception {
        this.setUpListenerReturnECs();
        this.ctx.rename(RDN, "cn=Jack Black");
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)"cn=Jack Black", (Object)this.listener.result.getName());
        Assert.assertEquals((Object)this.listener.result.control.getChangeType(), (Object)ChangeType.MODDN);
        Assert.assertEquals((Object)"cn=Tori Amos,ou=system", (Object)this.listener.result.control.getPreviousDn().getName());
    }

    @Test
    public void testPsearchDeleteWithEC() throws Exception {
        this.setUpListenerReturnECs();
        this.ctx.destroySubcontext(RDN);
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)RDN, (Object)this.listener.result.getName());
        Assert.assertEquals((Object)this.listener.result.control.getChangeType(), (Object)ChangeType.DELETE);
    }

    @Test
    public void testPsearchAddWithEC() throws Exception {
        this.setUpListenerReturnECs();
        this.ctx.createSubcontext("cn=Jack Black", this.getPersonAttributes("Black", "Jack Black"));
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)"cn=Jack Black", (Object)this.listener.result.getName());
        Assert.assertEquals((Object)this.listener.result.control.getChangeType(), (Object)ChangeType.ADD);
    }

    @Test
    public void testPsearchAddModifyEnabledWithEC() throws Exception {
        PersistentSearchImpl ctrl = new PersistentSearchImpl();
        ctrl.setReturnECs(true);
        ctrl.setChangeTypes(ChangeType.ADD.getValue());
        ctrl.enableNotification(ChangeType.MODIFY);
        this.setUpListener(true, (PersistentSearch)ctrl, false);
        this.ctx.createSubcontext("cn=Jack Black", this.getPersonAttributes("Black", "Jack Black"));
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)"cn=Jack Black", (Object)this.listener.result.getName());
        Assert.assertEquals((Object)this.listener.result.control.getChangeType(), (Object)ChangeType.ADD);
        this.tearDownListener();
        this.setUpListener(true, (PersistentSearch)ctrl, true);
        this.ctx.destroySubcontext("cn=Jack Black");
        this.waitForThreadToDie(this.t);
        Assert.assertNull((Object)this.listener.result);
        this.ctx.modifyAttributes(RDN, 3, (Attributes)new BasicAttributes("description", PERSON_DESCRIPTION, true));
        this.waitForThreadToDie(this.t);
        Assert.assertNotNull((Object)this.listener.result);
        Assert.assertEquals((Object)RDN, (Object)this.listener.result.getName());
        Assert.assertEquals((Object)this.listener.result.control.getChangeType(), (Object)ChangeType.MODIFY);
    }

    class PSearchNotification
    extends SearchResult {
        private static final long serialVersionUID = 1L;
        final EntryChange control;

        public PSearchNotification(SearchResult result, EntryChange control) {
            super(result.getName(), result.getClassName(), result.getObject(), result.getAttributes(), result.isRelative());
            this.control = control;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Dn: ").append(this.getName()).append("\n");
            if (this.control != null) {
                buf.append("    EntryChangeControl =\n");
                buf.append("       changeType   : ").append(this.control.getChangeType()).append("\n");
                buf.append("       previousDN   : ").append(this.control.getPreviousDn()).append("\n");
                buf.append("       changeNumber : ").append(this.control.getChangeNumber()).append("\n");
            }
            return buf.toString();
        }
    }

    class PSearchListener
    implements Runnable {
        boolean isReady = false;
        PSearchNotification result;
        final PersistentSearchDecorator persistentSearch;
        LdapContext ctx;
        NamingEnumeration<SearchResult> list;

        PSearchListener() {
            this.persistentSearch = new PersistentSearchDecorator(AbstractLdapTestUnit.getLdapServer().getDirectoryService().getLdapCodecService());
        }

        PSearchListener(PersistentSearch persistentSearch) {
            CodecControl wrapped = AbstractLdapTestUnit.getLdapServer().getDirectoryService().getLdapCodecService().newControl((Control)persistentSearch);
            this.persistentSearch = (PersistentSearchDecorator)wrapped;
        }

        void close() {
            if (this.list != null) {
                try {
                    this.list.close();
                    LOG.debug("PSearchListener: search naming enumeration closed()");
                }
                catch (Exception e) {
                    LOG.error("Error closing NamingEnumeration on PSearchListener", (Throwable)e);
                }
            }
            if (this.ctx != null) {
                try {
                    this.ctx.close();
                    LOG.debug("PSearchListener: search context closed()");
                }
                catch (Exception e) {
                    LOG.error("Error closing connection on PSearchListener", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug("PSearchListener.run() called.");
            LdapApiService codec = AbstractLdapTestUnit.getLdapServer().getDirectoryService().getLdapCodecService();
            this.persistentSearch.setCritical(true);
            this.persistentSearch.setValue(this.persistentSearch.getValue());
            Control[] ctxCtls = new Control[]{this.persistentSearch};
            try {
                this.ctx = (LdapContext)ServerIntegrationUtils.getWiredContext((LdapServer)AbstractLdapTestUnit.getLdapServer()).lookup(PersistentSearchIT.BASE);
                this.ctx.setRequestControls(JndiUtils.toJndiControls((LdapApiService)codec, (Control[])ctxCtls));
                this.isReady = true;
                LOG.debug("PSearchListener is ready and about to issue persistent search request.");
                this.list = this.ctx.search("", "objectClass=*", null);
                LOG.debug("PSearchListener search request returned.");
                EntryChange ecControl = null;
                if (this.list.hasMore()) {
                    javax.naming.ldap.Control[] controls;
                    LOG.debug("PSearchListener search request got an item.");
                    SearchResult sresult = this.list.next();
                    if (sresult instanceof HasControls && (controls = ((HasControls)((Object)sresult)).getControls()) != null) {
                        for (javax.naming.ldap.Control jndiControl : controls) {
                            if (!jndiControl.getID().equals("2.16.840.1.113730.3.4.7")) continue;
                            ecControl = (EntryChange)JndiUtils.fromJndiControl((LdapApiService)codec, (javax.naming.ldap.Control)jndiControl);
                            ((EntryChangeDecorator)ecControl).decode(jndiControl.getEncodedValue());
                        }
                    }
                    this.result = new PSearchNotification(sresult, ecControl);
                }
                LOG.debug("PSearchListener broke out of while loop.");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error("PSearchListener encountered error", (Throwable)e);
            }
        }
    }

    class JndiNotificationListener
    implements NamespaceChangeListener,
    ObjectChangeListener {
        boolean hasError = false;
        ArrayList<EventObject> list = new ArrayList();
        NamingExceptionEvent exceptionEvent = null;

        JndiNotificationListener() {
        }

        public void objectAdded(NamingEvent evt) {
            this.list.add(0, evt);
        }

        public void objectRemoved(NamingEvent evt) {
            this.list.add(0, evt);
        }

        public void objectRenamed(NamingEvent evt) {
            this.list.add(0, evt);
        }

        public void namingExceptionThrown(NamingExceptionEvent evt) {
            this.hasError = true;
            this.exceptionEvent = evt;
            this.list.add(0, evt);
        }

        public void objectChanged(NamingEvent evt) {
            this.list.add(0, evt);
        }
    }
}

