/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: ou=actors,ou=system", "objectClass: top", "objectClass: organizationalUnit", "ou: actors", "dn: uid=jblack,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: jblack", "ou: comedy", "ou: adventure", "cn: Jack Black", "sn: Black", "dn: uid=bpitt,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: bpitt", "ou: drama", "ou: adventure", "cn: Brad Pitt", "sn: Pitt", "dn: uid=gcloony,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: gcloony", "ou: drama", "cn: Goerge Cloony", "sn: Cloony", "dn: uid=jnewbie,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: jnewbie", "cn: Joe Newbie", "sn: Newbie"})
public class NegationSearchIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(true);

    @Test
    public void testSearchNotDrama() throws Exception {
        Set<SearchResult> results = this.getResults("(!(ou=drama))");
        Assert.assertTrue((boolean)this.contains("uid=jblack,ou=actors,ou=system", results));
        Assert.assertTrue((boolean)this.contains("uid=jnewbie,ou=actors,ou=system", results));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testSearchNotDramaNotNewbie() throws Exception {
        Set<SearchResult> results = this.getResults("(& (!(uid=jnewbie)) (!(ou=drama)) )");
        Assert.assertTrue((boolean)this.contains("uid=jblack,ou=actors,ou=system", results));
        Assert.assertFalse((boolean)this.contains("uid=jnewbie,ou=actors,ou=system", results));
        Assert.assertEquals((long)1L, (long)results.size());
    }

    boolean contains(String dn, Set<SearchResult> results) {
        for (SearchResult result : results) {
            if (!result.getNameInNamespace().equals(dn)) continue;
            return true;
        }
        return false;
    }

    Set<SearchResult> getResults(String filter) throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)NegationSearchIT.getLdapServer());
        HashSet<SearchResult> results = new HashSet<SearchResult>();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = ctx.search("ou=actors,ou=system", filter, controls);
        while (namingEnumeration.hasMore()) {
            results.add(namingEnumeration.next());
        }
        namingEnumeration.close();
        ctx.close();
        return results;
    }
}

