/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.bind;

import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@ApplyLdifs(value={"dn: uid=hnelson,ou=users,ou=system", "objectClass: inetOrgPerson", "objectClass: organizationalPerson", "objectClass: person", "objectClass: top", "userPassword: secret", "uid: hnelson", "cn: Horatio Nelson", "sn: Nelson"})
@CreateDS(allowAnonAccess=true, name="SimpleBindIT-class")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class SimpleBindIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final String BASE = "ou=users,ou=system";

    protected Attributes getPersonAttributes(String sn, String cn, String uid, String userPassword) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("person");
        ocls.add("inetOrgPerson");
        attrs.put(ocls);
        attrs.put("cn", cn);
        attrs.put("sn", sn);
        attrs.put("uid", uid);
        attrs.put("userPassword", userPassword);
        return attrs;
    }

    protected Attributes getOrgUnitAttributes(String ou) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("organizationalUnit");
        attrs.put(ocls);
        attrs.put("ou", ou);
        return attrs;
    }

    @Test
    public void testSimpleBind() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + SimpleBindIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "uid=hnelson,ou=users,ou=system");
        env.put("java.naming.security.credentials", "secret");
        try {
            InitialDirContext context = new InitialDirContext(env);
            String[] attrIDs = new String[]{"uid"};
            Attributes attrs = context.getAttributes("uid=hnelson,ou=users,ou=system", attrIDs);
            String uid = null;
            if (attrs.get("uid") != null) {
                uid = (String)attrs.get("uid").get();
            }
            Assert.assertEquals(uid, (Object)"hnelson");
        }
        catch (NamingException e) {
            Assert.fail((String)"Should not have caught exception.");
        }
    }

    @Test
    public void testSimpleBindBadPassword() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + SimpleBindIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "uid=hnelson,ou=users,ou=system");
        env.put("java.naming.security.credentials", "badsecret");
        try {
            new InitialDirContext(env);
        }
        catch (AuthenticationException ae) {
            Assert.assertTrue((boolean)ae.getMessage().contains("error code 49"));
        }
        catch (NamingException e) {
            Assert.fail();
        }
    }

    @Test
    public void testSimpleBindBadPrincipalAPassword() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + SimpleBindIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "hnelson");
        env.put("java.naming.security.credentials", "secret");
        try {
            new InitialDirContext(env);
        }
        catch (InvalidNameException ine) {
            Assert.assertTrue((boolean)ine.getMessage().startsWith("[LDAP: error code 34 - Incorrect Dn given"));
        }
        catch (NamingException e) {
            Assert.fail();
        }
    }

    @Test
    public void testSimpleBindUnknowPrincipalAPassword() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + SimpleBindIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "uid=unknown,ou=system");
        env.put("java.naming.security.credentials", "secret");
        try {
            new InitialDirContext(env);
        }
        catch (AuthenticationException ae) {
        }
        catch (NamingException e) {
            Assert.fail((String)("Expected AuthenticationException with error code 49 for invalidate credentials instead got: " + e.getMessage()));
        }
    }

    @Test
    public void testSimpleBindNoPrincipalNoPassword() {
        LDAPUrl url;
        boolean oldValue = SimpleBindIT.getLdapServer().getDirectoryService().isAllowAnonymousAccess();
        SimpleBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(false);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + SimpleBindIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "");
        env.put("java.naming.security.credentials", "");
        String[] attrIDs = new String[]{"*", "+"};
        try {
            new InitialDirContext(env);
            Assert.fail();
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            url = new LDAPUrl("localhost", SimpleBindIT.getLdapServer().getPort(), "", new String[]{"vendorName"}, 0, "(ObjectClass=*)");
            LDAPSearchResults results = LDAPConnection.search((LDAPUrl)url);
            if (results.hasMoreElements()) {
                LDAPEntry entry = results.next();
                LDAPAttribute vendorName = entry.getAttribute("vendorName");
                if (vendorName != null) {
                    Assert.assertEquals((Object)"Apache Software Foundation", (Object)vendorName.getStringValueArray()[0]);
                } else {
                    Assert.fail();
                }
            } else {
                Assert.fail();
            }
        }
        catch (LDAPException e) {
            Assert.fail((String)"Should not have caught exception.");
        }
        try {
            url = new LDAPUrl("localhost", SimpleBindIT.getLdapServer().getPort(), "uid=admin,ou=system", attrIDs, 0, "(ObjectClass=*)");
            LDAPConnection.search((LDAPUrl)url);
            Assert.fail();
        }
        catch (LDAPException e) {
            Assert.assertTrue((boolean)true);
        }
        SimpleBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(oldValue);
    }

    @Test
    public void testSimpleBindPrincipalNoPassword() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + SimpleBindIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "");
        try {
            new InitialDirContext(env);
        }
        catch (OperationNotSupportedException onse) {
            Assert.assertTrue((boolean)onse.getMessage().contains("error code 53"));
        }
        catch (NamingException ne) {
            Assert.fail();
        }
    }

    @Test
    public void testSimpleBindNoUserAPassword() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + SimpleBindIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "");
        env.put("java.naming.security.credentials", "secret");
        try {
            new InitialDirContext(env);
        }
        catch (AuthenticationException ae) {
        }
        catch (NamingException ne) {
            Assert.fail((String)("Expected AuthenticationException but instead got: " + ne.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnonymousRootDSESearch() {
        boolean oldValue = SimpleBindIT.getLdapServer().getDirectoryService().isAllowAnonymousAccess();
        SimpleBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(false);
        try {
            LDAPUrl url = new LDAPUrl("localhost", SimpleBindIT.getLdapServer().getPort(), "", new String[]{"vendorName"}, 0, "(ObjectClass=*)");
            LDAPSearchResults results = LDAPConnection.search((LDAPUrl)url);
            if (results.hasMoreElements()) {
                LDAPEntry entry = results.next();
                LDAPAttribute vendorName = entry.getAttribute("vendorName");
                if (vendorName != null) {
                    Assert.assertEquals((Object)"Apache Software Foundation", (Object)vendorName.getStringValueArray()[0]);
                } else {
                    Assert.fail();
                }
            } else {
                Assert.fail();
            }
        }
        catch (LDAPException e) {
            Assert.fail((String)"Should not have caught exception.");
        }
        finally {
            SimpleBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(oldValue);
        }
    }

    @Test
    public void testBindWithDoubleQuote() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SimpleBindIT.getLdapServer().getPort());
        connection.bind("uid=\"admin\",ou=\"system\"", "secret");
        Assert.assertTrue((boolean)connection.isAuthenticated());
        connection.close();
    }
}

