/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos;

import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.spec.DESKeySpec;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.kerberos.protocol.KerberosDecoder;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.plain.PlainMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=FrameworkRunner.class)
@CreateDS(name="KeyDerivationServiceIT-class", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})}, additionalInterceptors={KeyDerivationInterceptor.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, saslHost="localhost", saslMechanisms={@SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)}, extendedOpHandlers={StoredProcedureExtendedOperationHandler.class})
public class KeyDerivationServiceIT
extends AbstractLdapTestUnit {
    private static final String RDN = "uid=hnelson,ou=users,dc=example,dc=com";

    private void checkKeyNumber(Attributes attributes) {
        Attribute krb5key = attributes.get("krb5key");
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor.equalsIgnoreCase("IBM Corporation")) {
            Assert.assertTrue((String)"Number of keys", (krb5key.size() > 1 ? 1 : 0) != 0);
        } else if (vendor.equalsIgnoreCase("Sun Microsystems Inc.")) {
            Assert.assertTrue((String)"Number of keys", (krb5key.size() > 3 ? 1 : 0) != 0);
        } else if (vendor.equalsIgnoreCase("BEA Systems, Inc.")) {
            Assert.assertTrue((String)"Number of keys", (krb5key.size() > 3 ? 1 : 0) != 0);
        } else if (vendor.equalsIgnoreCase("Oracle Corporation")) {
            Assert.assertTrue((String)"Number of keys", (krb5key.size() > 3 ? 1 : 0) != 0);
        } else if (vendor.equalsIgnoreCase("Apple Inc.")) {
            Assert.assertTrue((String)"Number of keys", (krb5key.size() > 3 ? 1 : 0) != 0);
        } else if (vendor.equalsIgnoreCase("Apple Inc.")) {
            Assert.assertTrue((String)"Number of keys", (krb5key.size() > 3 ? 1 : 0) != 0);
        } else if (vendor.equalsIgnoreCase("\"Apple Computer, Inc.\"")) {
            Assert.assertTrue((String)"Number of keys", (krb5key.size() > 3 ? 1 : 0) != 0);
        } else {
            Assert.fail((String)"Unkown JVM");
        }
    }

    @Before
    public void setUp() throws Exception {
        DirContext schemaRoot = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)KeyDerivationServiceIT.getLdapServer()).lookup("ou=schema");
        Attributes krb5kdcAttrs = schemaRoot.getAttributes("cn=Krb5kdc");
        boolean isKrb5KdcDisabled = false;
        if (krb5kdcAttrs.get("m-disabled") != null) {
            isKrb5KdcDisabled = ((String)krb5kdcAttrs.get("m-disabled").get()).equalsIgnoreCase("TRUE");
        }
        if (isKrb5KdcDisabled) {
            BasicAttribute disabled = new BasicAttribute("m-disabled");
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, disabled)};
            schemaRoot.modifyAttributes("cn=Krb5kdc", mods);
        }
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)KeyDerivationServiceIT.getLdapServer()).lookup("dc=example,dc=com");
        Attributes attrs = this.getOrgUnitAttributes("users");
        DirContext users = ctx.createSubcontext("ou=users", attrs);
        attrs = this.getPersonAttributes("Nelson", "Horatio Nelson", "hnelson", "secret", "hnelson@EXAMPLE.COM");
        users.createSubcontext("uid=hnelson", attrs);
        ctx.close();
    }

    @Test
    public void testAddDerivedKeys() throws NamingException, KerberosException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + KeyDerivationServiceIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", RDN);
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.ldap.attributes.binary", "krb5key");
        InitialDirContext ctx = new InitialDirContext(env);
        String[] attrIDs = new String[]{"uid", "userPassword", "krb5Key", "krb5KeyVersionNumber"};
        Attributes attributes = ctx.getAttributes(RDN, attrIDs);
        String uid = null;
        if (attributes.get("uid") != null) {
            uid = (String)attributes.get("uid").get();
        }
        Assert.assertEquals(uid, (Object)"hnelson");
        byte[] userPassword = null;
        if (attributes.get("userPassword") != null) {
            userPassword = (byte[])attributes.get("userPassword").get();
        }
        this.checkKeyNumber(attributes);
        byte[] testPasswordBytes = new byte[]{115, 101, 99, 114, 101, 116};
        Assert.assertTrue((boolean)Arrays.equals(userPassword, testPasswordBytes));
        Attribute krb5key = attributes.get("krb5key");
        Map<EncryptionType, EncryptionKey> map = this.reconstituteKeyMap(krb5key);
        EncryptionKey encryptionKey = map.get(EncryptionType.DES_CBC_MD5);
        byte[] testKeyBytes = new byte[]{-12, -89, 19, 100, -118, 97, -50, 91};
        Assert.assertTrue((boolean)Arrays.equals(encryptionKey.getKeyValue(), testKeyBytes));
        Assert.assertEquals((Object)EncryptionType.DES_CBC_MD5, (Object)encryptionKey.getKeyType());
        int keyVersionNumber = -1;
        if (attributes.get("krb5KeyVersionNumber") != null) {
            keyVersionNumber = Integer.valueOf((String)attributes.get("krb5KeyVersionNumber").get());
        }
        Assert.assertEquals((String)"Key version number", (long)0L, (long)keyVersionNumber);
        ctx.close();
    }

    @Test
    public void testModifyDerivedKeys() throws NamingException, KerberosException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + KeyDerivationServiceIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", RDN);
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.ldap.attributes.binary", "krb5key");
        InitialDirContext ctx = new InitialDirContext(env);
        String newPrincipalName = "hnelson@EXAMPLE.COM";
        String newUserPassword = "secretsecret";
        Attributes attributes = new BasicAttributes(true);
        BasicAttribute attr = new BasicAttribute("userPassword", newUserPassword);
        attributes.put(attr);
        attr = new BasicAttribute("krb5PrincipalName", newPrincipalName);
        attributes.put(attr);
        DirContext person = (DirContext)ctx.lookup(RDN);
        person.modifyAttributes("", 2, attributes);
        person = (DirContext)ctx.lookup(RDN);
        attributes = person.getAttributes("");
        byte[] userPassword = null;
        if (attributes.get("userPassword") != null) {
            userPassword = (byte[])attributes.get("userPassword").get();
        }
        this.checkKeyNumber(attributes);
        byte[] testBytes = new byte[]{115, 101, 99, 114, 101, 116, 115, 101, 99, 114, 101, 116};
        Assert.assertTrue((boolean)Arrays.equals(userPassword, testBytes));
        Attribute krb5key = attributes.get("krb5key");
        Map<EncryptionType, EncryptionKey> map = this.reconstituteKeyMap(krb5key);
        EncryptionKey encryptionKey = map.get(EncryptionType.DES_CBC_MD5);
        byte[] testKeyBytes = new byte[]{22, 74, 109, -119, 93, 118, 14, 35};
        Assert.assertTrue((boolean)Arrays.equals(encryptionKey.getKeyValue(), testKeyBytes));
        Assert.assertEquals((Object)EncryptionType.DES_CBC_MD5, (Object)encryptionKey.getKeyType());
        int keyVersionNumber = -1;
        if (attributes.get("krb5KeyVersionNumber") != null) {
            keyVersionNumber = Integer.valueOf((String)attributes.get("krb5KeyVersionNumber").get());
        }
        Assert.assertEquals((String)"Key version number", (long)1L, (long)keyVersionNumber);
        newUserPassword = "secretsecretsecret";
        attributes = new BasicAttributes(true);
        attr = new BasicAttribute("userPassword", newUserPassword);
        attributes.put(attr);
        attr = new BasicAttribute("krb5PrincipalName", newPrincipalName);
        attributes.put(attr);
        person = (DirContext)ctx.lookup(RDN);
        person.modifyAttributes("", 2, attributes);
        person = (DirContext)ctx.lookup(RDN);
        attributes = person.getAttributes("");
        if (attributes.get("userPassword") != null) {
            userPassword = (byte[])attributes.get("userPassword").get();
        }
        Assert.assertEquals((String)"password length", (long)18L, (long)userPassword.length);
        if (attributes.get("krb5KeyVersionNumber") != null) {
            keyVersionNumber = Integer.valueOf((String)attributes.get("krb5KeyVersionNumber").get());
        }
        Assert.assertEquals((String)"Key version number", (long)2L, (long)keyVersionNumber);
        newUserPassword = "secretsecretsecretsecret";
        attributes = new BasicAttributes(true);
        attr = new BasicAttribute("userPassword", newUserPassword);
        attributes.put(attr);
        attr = new BasicAttribute("krb5PrincipalName", newPrincipalName);
        attributes.put(attr);
        person = (DirContext)ctx.lookup(RDN);
        person.modifyAttributes("", 2, attributes);
        person = (DirContext)ctx.lookup(RDN);
        attributes = person.getAttributes("");
        if (attributes.get("userPassword") != null) {
            userPassword = (byte[])attributes.get("userPassword").get();
        }
        Assert.assertEquals((String)"password length", (long)24L, (long)userPassword.length);
        if (attributes.get("krb5KeyVersionNumber") != null) {
            keyVersionNumber = Integer.valueOf((String)attributes.get("krb5KeyVersionNumber").get());
        }
        Assert.assertEquals((String)"Key version number", (long)3L, (long)keyVersionNumber);
        ctx.close();
    }

    @Test
    public void testModifyDerivedKeysWithoutPrincipalName() throws NamingException, KerberosException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + KeyDerivationServiceIT.getLdapServer().getPort());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", RDN);
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.ldap.attributes.binary", "krb5key");
        InitialDirContext ctx = new InitialDirContext(env);
        String newUserPassword = "secretsecret";
        Attributes attributes = new BasicAttributes(true);
        BasicAttribute attr = new BasicAttribute("userPassword", newUserPassword);
        attributes.put(attr);
        DirContext person = (DirContext)ctx.lookup(RDN);
        person.modifyAttributes("", 2, attributes);
        person = (DirContext)ctx.lookup(RDN);
        attributes = person.getAttributes("");
        byte[] userPassword = null;
        if (attributes.get("userPassword") != null) {
            userPassword = (byte[])attributes.get("userPassword").get();
        }
        this.checkKeyNumber(attributes);
        byte[] testBytes = new byte[]{115, 101, 99, 114, 101, 116, 115, 101, 99, 114, 101, 116};
        Assert.assertTrue((boolean)Arrays.equals(userPassword, testBytes));
        Attribute krb5key = attributes.get("krb5key");
        Map<EncryptionType, EncryptionKey> map = this.reconstituteKeyMap(krb5key);
        EncryptionKey encryptionKey = map.get(EncryptionType.DES_CBC_MD5);
        byte[] testKeyBytes = new byte[]{22, 74, 109, -119, 93, 118, 14, 35};
        Assert.assertTrue((boolean)Arrays.equals(encryptionKey.getKeyValue(), testKeyBytes));
        Assert.assertEquals((Object)EncryptionType.DES_CBC_MD5, (Object)encryptionKey.getKeyType());
        int keyVersionNumber = -1;
        if (attributes.get("krb5KeyVersionNumber") != null) {
            keyVersionNumber = Integer.valueOf((String)attributes.get("krb5KeyVersionNumber").get());
        }
        Assert.assertEquals((String)"Key version number", (long)1L, (long)keyVersionNumber);
        newUserPassword = "secretsecretsecret";
        attributes = new BasicAttributes(true);
        attr = new BasicAttribute("userPassword", newUserPassword);
        attributes.put(attr);
        person = (DirContext)ctx.lookup(RDN);
        person.modifyAttributes("", 2, attributes);
        person = (DirContext)ctx.lookup(RDN);
        attributes = person.getAttributes("");
        if (attributes.get("userPassword") != null) {
            userPassword = (byte[])attributes.get("userPassword").get();
        }
        Assert.assertEquals((String)"password length", (long)18L, (long)userPassword.length);
        if (attributes.get("krb5KeyVersionNumber") != null) {
            keyVersionNumber = Integer.valueOf((String)attributes.get("krb5KeyVersionNumber").get());
        }
        Assert.assertEquals((String)"Key version number", (long)2L, (long)keyVersionNumber);
        newUserPassword = "secretsecretsecretsecret";
        attributes = new BasicAttributes(true);
        attr = new BasicAttribute("userPassword", newUserPassword);
        attributes.put(attr);
        person = (DirContext)ctx.lookup(RDN);
        person.modifyAttributes("", 2, attributes);
        person = (DirContext)ctx.lookup(RDN);
        attributes = person.getAttributes("");
        if (attributes.get("userPassword") != null) {
            userPassword = (byte[])attributes.get("userPassword").get();
        }
        Assert.assertEquals((String)"password length", (long)24L, (long)userPassword.length);
        if (attributes.get("krb5KeyVersionNumber") != null) {
            keyVersionNumber = Integer.valueOf((String)attributes.get("krb5KeyVersionNumber").get());
        }
        Assert.assertEquals((String)"Key version number", (long)3L, (long)keyVersionNumber);
        ctx.close();
    }

    @Test
    public void testAddRandomKeys() throws NamingException, KerberosException, InvalidKeyException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + KeyDerivationServiceIT.getLdapServer().getPort() + "/ou=users,dc=example,dc=com");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.ldap.attributes.binary", "krb5key");
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes attrs = this.getPersonAttributes("Quist", "Thomas Quist", "tquist", "randomKey", "tquist@EXAMPLE.COM");
        ctx.createSubcontext("uid=tquist", attrs);
        attrs = this.getPersonAttributes("Fryer", "John Fryer", "jfryer", "randomKey", "jfryer@EXAMPLE.COM");
        ctx.createSubcontext("uid=jfryer", attrs);
        String[] attrIDs = new String[]{"uid", "userPassword", "krb5Key"};
        Attributes tquistAttrs = ctx.getAttributes("uid=tquist", attrIDs);
        Attributes jfryerAttrs = ctx.getAttributes("uid=jfryer", attrIDs);
        String uid = null;
        byte[] userPassword = null;
        if (tquistAttrs.get("uid") != null) {
            uid = (String)tquistAttrs.get("uid").get();
        }
        Assert.assertEquals((Object)"tquist", uid);
        if (tquistAttrs.get("userPassword") != null) {
            userPassword = (byte[])tquistAttrs.get("userPassword").get();
        }
        byte[] testPasswordBytes = new byte[]{114, 97, 110, 100, 111, 109, 75, 101, 121};
        Assert.assertTrue((boolean)Arrays.equals(testPasswordBytes, userPassword));
        if (jfryerAttrs.get("uid") != null) {
            uid = (String)jfryerAttrs.get("uid").get();
        }
        Assert.assertEquals((Object)"jfryer", (Object)uid);
        if (jfryerAttrs.get("userPassword") != null) {
            userPassword = (byte[])jfryerAttrs.get("userPassword").get();
        }
        Assert.assertTrue((boolean)Arrays.equals(testPasswordBytes, userPassword));
        byte[] testKeyBytes = new byte[]{-12, -89, 19, 100, -118, 97, -50, 91};
        Attribute krb5key = tquistAttrs.get("krb5key");
        Map<EncryptionType, EncryptionKey> map = this.reconstituteKeyMap(krb5key);
        EncryptionKey encryptionKey = map.get(EncryptionType.DES_CBC_MD5);
        byte[] tquistKey = encryptionKey.getKeyValue();
        Assert.assertEquals((Object)EncryptionType.DES_CBC_MD5, (Object)encryptionKey.getKeyType());
        krb5key = jfryerAttrs.get("krb5key");
        map = this.reconstituteKeyMap(krb5key);
        encryptionKey = map.get(EncryptionType.DES_CBC_MD5);
        byte[] jfryerKey = encryptionKey.getKeyValue();
        Assert.assertEquals((Object)EncryptionType.DES_CBC_MD5, (Object)encryptionKey.getKeyType());
        Assert.assertEquals((String)"Key length", (long)8L, (long)tquistKey.length);
        Assert.assertEquals((String)"Key length", (long)8L, (long)jfryerKey.length);
        Assert.assertFalse((boolean)Arrays.equals(testKeyBytes, tquistKey));
        Assert.assertFalse((boolean)Arrays.equals(testKeyBytes, jfryerKey));
        Assert.assertFalse((boolean)Arrays.equals(jfryerKey, tquistKey));
        byte[] tquistDerivedKey = new byte[]{-3, 127, 107, -125, -92, 118, -63, -22};
        byte[] jfryerDerivedKey = new byte[]{-92, 16, 59, 73, -50, 11, -75, 7};
        Assert.assertFalse((boolean)Arrays.equals(tquistDerivedKey, tquistKey));
        Assert.assertFalse((boolean)Arrays.equals(jfryerDerivedKey, jfryerKey));
        Assert.assertTrue((boolean)DESKeySpec.isParityAdjusted(tquistKey, 0));
        Assert.assertTrue((boolean)DESKeySpec.isParityAdjusted(jfryerKey, 0));
        ctx.close();
    }

    protected Attributes getPersonAttributes(String sn, String cn, String uid, String userPassword, String principal) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("person");
        ocls.add("inetOrgPerson");
        ocls.add("krb5principal");
        ocls.add("krb5kdcentry");
        attrs.put(ocls);
        attrs.put("cn", cn);
        attrs.put("sn", sn);
        attrs.put("uid", uid);
        attrs.put("userPassword", userPassword);
        attrs.put("krb5PrincipalName", principal);
        attrs.put("krb5KeyVersionNumber", "0");
        return attrs;
    }

    protected Attributes getOrgUnitAttributes(String ou) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("organizationalUnit");
        attrs.put(ocls);
        attrs.put("ou", ou);
        return attrs;
    }

    private Map<EncryptionType, EncryptionKey> reconstituteKeyMap(Attribute krb5key) throws NamingException, KerberosException {
        HashMap<EncryptionType, EncryptionKey> map = new HashMap<EncryptionType, EncryptionKey>();
        for (int ii = 0; ii < krb5key.size(); ++ii) {
            byte[] encryptionKeyBytes = (byte[])krb5key.get(ii);
            EncryptionKey encryptionKey = KerberosDecoder.decodeEncryptionKey((byte[])encryptionKeyBytes);
            map.put(encryptionKey.getKeyType(), encryptionKey);
        }
        return map;
    }
}

