/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ.state;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.naming.NamingException;
import org.apache.directory.server.integ.InheritableServerSettings;
import org.apache.directory.server.integ.state.NonExistentState;
import org.apache.directory.server.integ.state.StartedNormalState;
import org.apache.directory.server.integ.state.StartedPristineState;
import org.apache.directory.server.integ.state.TestServerState;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServerContext {
    private static final Logger LOG = LoggerFactory.getLogger(TestServerContext.class);
    private static final ThreadLocal<TestServerContext> CONTEXTS = new ThreadLocal();
    private final TestServerState nonExistentState = new NonExistentState(this);
    private final TestServerState startedPristineState = new StartedPristineState(this);
    private final TestServerState startedNormalState = new StartedNormalState(this);
    private TestServerState state = this.nonExistentState;
    private LdapServer ldapServer;

    private TestServerContext() {
    }

    public static TestServerContext getServerContext() {
        TestServerContext context = CONTEXTS.get();
        if (context == null) {
            context = new TestServerContext();
            CONTEXTS.set(context);
        }
        return context;
    }

    public static void set(TestServerContext context) {
        CONTEXTS.set(context);
    }

    public static void create(InheritableServerSettings settings) throws NamingException {
        TestServerState state = TestServerContext.getServerContext().getState();
        state.create(settings);
    }

    public static void destroy() {
        TestServerState state = TestServerContext.getServerContext().getState();
        state.destroy();
    }

    public static void cleanup() throws IOException {
        TestServerState state = TestServerContext.getServerContext().getState();
        state.cleanup();
    }

    public static void startup() throws Exception {
        TestServerState state = TestServerContext.getServerContext().getState();
        state.startup();
    }

    public static void shutdown() throws Exception {
        TestServerState state = TestServerContext.getServerContext().getState();
        state.shutdown();
    }

    public static void test(TestClass testClass, Statement statement, RunNotifier notifier, InheritableServerSettings settings) {
        LOG.debug("calling test(): {}", (Object)settings.getDescription().getDisplayName());
        TestServerState state = TestServerContext.getServerContext().getState();
        state.test(testClass, statement, notifier, settings);
    }

    public static void revert() throws Exception {
        TestServerState state = TestServerContext.getServerContext().getState();
        state.revert();
    }

    static void invokeTest(TestClass testClass, Statement statement, RunNotifier notifier, Description description) {
        try {
            Field field = testClass.getJavaClass().getDeclaredField("ldapServer");
            field.set(testClass.getJavaClass(), TestServerContext.getServerContext().getLdapServer());
            notifier.fireTestStarted(description);
            statement.evaluate();
            notifier.fireTestFinished(description);
        }
        catch (InvocationTargetException e) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), e.getCause());
            TestServerContext.testAborted(notifier, description, e.getCause());
            return;
        }
        catch (InstantiationException ie) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), (Throwable)ie);
            TestServerContext.testAborted(notifier, description, ie);
            return;
        }
        catch (IllegalAccessException iae) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), (Throwable)iae);
            TestServerContext.testAborted(notifier, description, iae);
            return;
        }
        catch (NoSuchMethodException nsme) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), (Throwable)nsme);
            TestServerContext.testAborted(notifier, description, nsme);
            return;
        }
        catch (NoSuchFieldException nsfe) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), (Throwable)nsfe);
            TestServerContext.testAborted(notifier, description, nsfe);
            return;
        }
        catch (Throwable t) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), t);
            TestServerContext.testAborted(notifier, description, t);
            return;
        }
    }

    void setState(TestServerState state) {
        this.state = state;
    }

    TestServerState getState() {
        return this.state;
    }

    TestServerState getNonExistentState() {
        return this.nonExistentState;
    }

    TestServerState getStartedPristineState() {
        return this.startedPristineState;
    }

    TestServerState getStartedNormalState() {
        return this.startedNormalState;
    }

    LdapServer getLdapServer() {
        return this.ldapServer;
    }

    void setLdapServer(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    private static void testAborted(RunNotifier notifier, Description description, Throwable cause) {
        notifier.fireTestStarted(description);
        notifier.fireTestFailure(new Failure(description, cause));
        notifier.fireTestFinished(description);
    }
}

