/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ;

import java.util.Hashtable;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPConnection;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.LdapService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIntegrationUtils
extends IntegrationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServerIntegrationUtils.class);
    private static final String CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 10389;
    private static final String DEFAULT_ADMIN = "uid=admin,ou=system";
    private static final String DEFAULT_PASSWORD = "secret";

    public static LdapContext getWiredContext(LdapService ldapService) throws Exception {
        return ServerIntegrationUtils.getWiredContext(ldapService, null);
    }

    public static LdapContext getWiredContext(LdapService ldapService, String principalDn, String password) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapService.getIpPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://localhost:" + ldapService.getIpPort());
        env.put("java.naming.security.principal", principalDn);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContext(LdapService ldapService, Control[] controls) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapService.getIpPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://localhost:" + ldapService.getIpPort());
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        return new InitialLdapContext(env, controls);
    }

    public static LdapContext getWiredContextThrowOnRefferal(LdapService ldapService) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapService.getIpPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://localhost:" + ldapService.getIpPort());
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.referral", "throw");
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContextRefferalIgnore(LdapService ldapService) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapService.getIpPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://localhost:" + ldapService.getIpPort());
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.referral", "ignore");
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContextFollowOnRefferal(LdapService ldapService) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapService.getIpPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://localhost:" + ldapService.getIpPort());
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.referral", "follow");
        return new InitialLdapContext(env, null);
    }

    public static LDAPConnection getWiredConnection(LdapService ldapService) throws Exception {
        String testServer = System.getProperty("ldap.test.server", null);
        if (testServer == null) {
            return ServerIntegrationUtils.getWiredConnection(ldapService, DEFAULT_ADMIN, DEFAULT_PASSWORD);
        }
        LOG.debug("ldap.test.server = " + testServer);
        String admin = System.getProperty(testServer + ".admin", DEFAULT_ADMIN);
        LOG.debug(testServer + ".admin = " + admin);
        String password = System.getProperty(testServer + ".password", DEFAULT_PASSWORD);
        LOG.debug(testServer + ".password = " + password);
        String host = System.getProperty(testServer + ".host", DEFAULT_HOST);
        LOG.debug(testServer + ".host = " + host);
        int port = Integer.parseInt(System.getProperty(testServer + ".port", Integer.toString(10389)));
        LOG.debug(testServer + ".port = " + port);
        LDAPConnection conn = new LDAPConnection();
        conn.connect(3, host, port, admin, password);
        return conn;
    }

    public static LDAPConnection getWiredConnection(LdapService ldapService, String principalDn, String password) throws Exception {
        LDAPConnection conn = new LDAPConnection();
        conn.connect(3, DEFAULT_HOST, ldapService.getIpPort(), principalDn, password);
        return conn;
    }
}

