/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;


/**
 * A producer of schema objectClass definations for the system schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$
 */
public class SystemObjectClassProducer extends AbstractBootstrapProducer
{

    public SystemObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.0 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.0", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "top of the superclass chain" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.ABSTRACT );
        
        // set superior objectClasses
        array.clear();
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "objectClass" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "top" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.0", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.1466.101.120.111 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.1466.101.120.111", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2252: extensible object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "extensibleObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.120.111", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.1", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: an alias" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "aliasedObjectName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "alias" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.1", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113730.3.2.6 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113730.3.2.6", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "namedref: named subordinate referral" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "ref" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "referral" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.2.6", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.4203.1.4.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.4203.1.4.1", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "OpenLDAP Root DSE object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "cn" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "OpenLDAProotDSE" );
        array.add( "LDAProotDSE" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.4203.1.4.1", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.17.0 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.17.0", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "subtreeSpecification" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "subentry" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.17.0", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.20.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.20.1", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2252: controlling subschema (sub)entry" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "dITStructureRules" );
        array.add( "nameForms" );
        array.add( "ditContentRules" );
        array.add( "objectClasses" );
        array.add( "attributeTypes" );
        array.add( "matchingRules" );
        array.add( "matchingRuleUse" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "subschema" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.20.1", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.17.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.17.2", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "collectiveAttributeSubentry" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.17.2", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.1466.101.119.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.1466.101.119.2", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2589: Dynamic Object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "dynamicObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.119.2", objectClass );

    }
}
