/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.catalog;

import java.util.HashMap;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;

public class GetCatalog
implements DirectoryServiceOperation {
    private static final long serialVersionUID = -6657995003127926278L;

    public Object execute(CoreSession session, DN base) throws Exception {
        String filter = "(objectClass=apacheCatalogEntry)";
        EntryFilteringCursor list = session.search(DN.EMPTY_DN, SearchScope.SUBTREE, FilterParser.parse((String)filter), AliasDerefMode.DEREF_ALWAYS, null);
        HashMap<String, String> catalog = new HashMap<String, String>();
        list.beforeFirst();
        while (list.next()) {
            ServerEntry result = (ServerEntry)list.get();
            String name = null;
            EntryAttribute attribute = result.get("apacheCatalogEntryName");
            if (attribute != null) {
                name = attribute.getString();
            }
            String basedn = null;
            attribute = result.get("apacheCatalogEntryBaseDn");
            if (attribute != null) {
                basedn = attribute.getString();
            }
            catalog.put(name, basedn);
        }
        return catalog;
    }
}

