/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.chain.impl;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.server.protocol.shared.chain.Chain;
import org.apache.directory.server.protocol.shared.chain.Command;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.Filter;

public class ChainBase
implements Chain {
    protected Command[] commands = new Command[0];
    protected boolean frozen = false;

    public ChainBase() {
    }

    public ChainBase(Command command) {
        this.addCommand(command);
    }

    public ChainBase(Command[] commands) {
        if (commands == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < commands.length) {
            this.addCommand(commands[i]);
            ++i;
        }
    }

    public ChainBase(Collection commands) {
        if (commands == null) {
            throw new IllegalArgumentException();
        }
        Iterator elements = commands.iterator();
        while (elements.hasNext()) {
            this.addCommand((Command)elements.next());
        }
    }

    public void addCommand(Command command) {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        if (this.frozen) {
            throw new IllegalStateException();
        }
        Command[] results = new Command[this.commands.length + 1];
        System.arraycopy(this.commands, 0, results, 0, this.commands.length);
        results[this.commands.length] = command;
        this.commands = results;
    }

    public boolean execute(Context context) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.frozen = true;
        boolean saveResult = false;
        Exception saveException = null;
        int i = 0;
        int n = this.commands.length;
        i = 0;
        while (i < n) {
            block12: {
                try {
                    saveResult = this.commands[i].execute(context);
                    if (saveResult) {
                    }
                    break block12;
                }
                catch (Exception e) {
                    saveException = e;
                }
                break;
            }
            ++i;
        }
        if (i >= n) {
            --i;
        }
        boolean handled = false;
        boolean result = false;
        int j = i;
        while (j >= 0) {
            if (this.commands[j] instanceof Filter) {
                try {
                    result = ((Filter)this.commands[j]).postprocess(context, saveException);
                    if (result) {
                        handled = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            --j;
        }
        if (saveException != null && !handled) {
            throw saveException;
        }
        return saveResult;
    }

    Command[] getCommands() {
        return this.commands;
    }
}

