/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp.io;

import java.nio.ByteBuffer;
import org.apache.directory.server.ntp.messages.LeapIndicatorType;
import org.apache.directory.server.ntp.messages.ModeType;
import org.apache.directory.server.ntp.messages.NtpMessage;
import org.apache.directory.server.ntp.messages.NtpMessageModifier;
import org.apache.directory.server.ntp.messages.NtpTimeStamp;
import org.apache.directory.server.ntp.messages.ReferenceIdentifier;
import org.apache.directory.server.ntp.messages.StratumType;

public class NtpMessageDecoder {
    public NtpMessage decode(ByteBuffer request) {
        NtpMessageModifier modifier = new NtpMessageModifier();
        byte header = request.get();
        modifier.setLeapIndicator(this.parseLeapIndicator(header));
        modifier.setVersionNumber(this.parseVersionNumber(header));
        modifier.setMode(this.parseMode(header));
        modifier.setStratum(this.parseStratum(request));
        modifier.setPollInterval(this.parsePollInterval(request));
        modifier.setPrecision(this.parsePrecision(request));
        modifier.setRootDelay(this.parseRootDelay(request));
        modifier.setRootDispersion(this.parseRootDispersion(request));
        modifier.setReferenceIdentifier(this.parseReferenceIdentifier(request));
        modifier.setReferenceTimestamp(new NtpTimeStamp(request));
        modifier.setOriginateTimestamp(new NtpTimeStamp(request));
        byte[] unneededBytes = new byte[8];
        request.get(unneededBytes);
        modifier.setReceiveTimestamp(new NtpTimeStamp());
        modifier.setTransmitTimestamp(new NtpTimeStamp(request));
        return modifier.getNtpMessage();
    }

    private LeapIndicatorType parseLeapIndicator(byte header) {
        return LeapIndicatorType.getTypeByOrdinal((header & 0xC0) >>> 6);
    }

    private int parseVersionNumber(byte header) {
        return (header & 0x38) >>> 3;
    }

    private ModeType parseMode(byte header) {
        return ModeType.getTypeByOrdinal(header & 7);
    }

    private StratumType parseStratum(ByteBuffer request) {
        return StratumType.getTypeByOrdinal(request.get());
    }

    private byte parsePollInterval(ByteBuffer bytes) {
        return (byte)Math.round(Math.pow(2.0, bytes.get()));
    }

    private byte parsePrecision(ByteBuffer bytes) {
        return (byte)(1000.0 * Math.pow(2.0, bytes.get()));
    }

    private ReferenceIdentifier parseReferenceIdentifier(ByteBuffer request) {
        byte[] nextFourBytes = new byte[4];
        request.get(nextFourBytes);
        return ReferenceIdentifier.getTypeByName(new String(nextFourBytes));
    }

    private int parseRootDelay(ByteBuffer bytes) {
        int temp = 256 * (256 * (256 * bytes.get() + bytes.get()) + bytes.get()) + bytes.get();
        return 1000 * (temp / 65536);
    }

    private int parseRootDispersion(ByteBuffer bytes) {
        int temp = 256 * (256 * (256 * bytes.get() + bytes.get()) + bytes.get()) + bytes.get();
        return 1000 * (temp / 65536);
    }
}

