/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.directory.server.ntp.protocol.NtpProtocolHandler;
import org.apache.directory.server.protocol.shared.AbstractProtocolService;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class NtpServer
extends AbstractProtocolService {
    private static final int IP_PORT_DEFAULT = 123;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.ntp";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS NTP Service";

    public NtpServer() {
        super.setIpPort(123);
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
    }

    public void start() throws IOException {
        if (this.getDatagramAcceptor() != null) {
            DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
            this.getDatagramAcceptor().bind((SocketAddress)new InetSocketAddress(this.getIpPort()), (IoHandler)new NtpProtocolHandler(), (IoServiceConfig)udpConfig);
        }
        if (this.getSocketAcceptor() != null) {
            SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
            tcpConfig.setDisconnectOnUnbind(false);
            tcpConfig.setReuseAddress(true);
            this.getSocketAcceptor().bind((SocketAddress)new InetSocketAddress(this.getIpPort()), (IoHandler)new NtpProtocolHandler(), (IoServiceConfig)tcpConfig);
        }
    }

    public void stop() {
        if (this.getDatagramAcceptor() != null) {
            this.getDatagramAcceptor().unbind((SocketAddress)new InetSocketAddress(this.getIpPort()));
        }
        if (this.getSocketAcceptor() != null) {
            this.getSocketAcceptor().unbind((SocketAddress)new InetSocketAddress(this.getIpPort()));
        }
    }
}

