/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp.protocol;

import org.apache.directory.server.ntp.NtpService;
import org.apache.directory.server.ntp.messages.NtpMessage;
import org.apache.directory.server.ntp.protocol.NtpProtocolCodecFactory;
import org.apache.directory.server.ntp.service.NtpServiceImpl;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtpProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger(NtpProtocolHandler.class);
    private NtpService ntpService = new NtpServiceImpl();

    public void sessionCreated(IoSession session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " CREATED");
        }
        session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)NtpProtocolCodecFactory.getInstance()));
    }

    public void sessionOpened(IoSession session) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " OPENED");
        }
    }

    public void sessionClosed(IoSession session) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " CLOSED");
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " IDLE(" + status + ")");
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.error(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close();
    }

    public void messageReceived(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " RCVD: " + message);
        }
        NtpMessage reply = this.ntpService.getReplyFor((NtpMessage)message);
        session.write((Object)reply);
    }

    public void messageSent(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " SENT: " + message);
        }
    }
}

