/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.X509CertParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplicationTrustManager
implements X509TrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationTrustManager.class);
    private static X509TrustManager trustManager = null;
    private static KeyStore ks;
    private static X509CertParser parser;
    private static final ReplicationTrustManager INSTANCE;

    private ReplicationTrustManager() {
        try {
            ks.load(null, null);
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmFactory.init(ks);
            TrustManager[] trustManagers = tmFactory.getTrustManagers();
            for (int i = 0; i < trustManagers.length; ++i) {
                if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                trustManager = (X509TrustManager)trustManagers[i];
                LOG.debug("found X509TrustManager {}", (Object)trustManager);
                break;
            }
        }
        catch (Exception e) {
            LOG.error("failed to initialize the keystore and X509 trustmanager", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void addCertificates(Map<String, byte[]> aliasCertMap) throws Exception {
        for (Map.Entry<String, byte[]> entry : aliasCertMap.entrySet()) {
            ReplicationTrustManager.addCertificate(entry.getKey(), entry.getValue());
        }
    }

    public static void addCertificate(String certAlias, byte[] certificate) throws Exception {
        try {
            parser.engineInit((InputStream)new ByteArrayInputStream(certificate));
            X509Certificate cert = (X509Certificate)parser.engineRead();
            ks.setCertificateEntry(certAlias, cert);
        }
        catch (Exception ex) {
            LOG.warn("failed to load the certificate associated with the alias {}", (Object)certAlias, (Object)ex);
            throw ex;
        }
    }

    public static ReplicationTrustManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return trustManager.getAcceptedIssuers();
    }

    static {
        parser = new X509CertParser();
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (Exception e) {
            LOG.error("failed to initialize the keystore and X509 trustmanager", (Throwable)e);
            throw new RuntimeException(e);
        }
        INSTANCE = new ReplicationTrustManager();
    }
}

