/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.sasl.plain;

import javax.security.sasl.SaslServer;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.sasl.AbstractMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.plain.PlainSaslServer;

public class PlainMechanismHandler
extends AbstractMechanismHandler {
    @Override
    public SaslServer handleMechanism(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        SaslServer ss = (SaslServer)ldapSession.getSaslProperty("saslServer");
        if (ss == null) {
            CoreSession adminSession = ldapSession.getLdapServer().getDirectoryService().getAdminSession();
            ss = new PlainSaslServer(ldapSession, adminSession, bindRequest);
            ldapSession.putSaslProperty("saslServer", ss);
        }
        return ss;
    }

    @Override
    public void init(LdapSession ldapSession) {
    }

    @Override
    public void cleanup(LdapSession ldapSession) {
        ldapSession.clearSaslProperties();
    }
}

