/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.kerberos.kdc;


import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev: 558926 $, $Date: 2007-07-24 00:39:32 -0400 (Tue, 24 Jul 2007) $
 */
public class MonitorReply implements IoHandlerCommand
{
    /** the log for this class */
    private static final Logger log = LoggerFactory.getLogger( MonitorReply.class );

    private String serviceName;

    private String contextKey = "context";


    /**
     * Creates a new instance of MonitorReply.
     *
     * @param serviceName
     */
    public MonitorReply( String serviceName )
    {
        this.serviceName = serviceName;
    }


    public void execute( NextCommand next, IoSession session, Object message ) throws Exception
    {
        KdcContext kdcContext = ( KdcContext ) session.getAttribute( getContextKey() );
        Object reply = kdcContext.getReply();

        if ( log.isDebugEnabled() )
        {
            if ( reply instanceof KdcReply )
            {
                KdcReply success = ( KdcReply ) reply;

                try
                {
                    StringBuffer sb = new StringBuffer();

                    sb.append( "Responding with " + serviceName + " reply:" );
                    sb.append( "\n\t" + "messageType:           " + success.getMessageType() );
                    sb.append( "\n\t" + "protocolVersionNumber: " + success.getProtocolVersionNumber() );
                    sb.append( "\n\t" + "nonce:                 " + success.getNonce() );
                    sb.append( "\n\t" + "clientPrincipal:       " + success.getClientPrincipal() );
                    sb.append( "\n\t" + "client realm:          " + success.getClientRealm() );
                    sb.append( "\n\t" + "serverPrincipal:       " + success.getServerPrincipal() );
                    sb.append( "\n\t" + "server realm:          " + success.getServerRealm() );
                    sb.append( "\n\t" + "auth time:             " + success.getAuthTime() );
                    sb.append( "\n\t" + "start time:            " + success.getStartTime() );
                    sb.append( "\n\t" + "end time:              " + success.getEndTime() );
                    sb.append( "\n\t" + "renew-till time:       " + success.getRenewTill() );
                    sb.append( "\n\t" + "hostAddresses:         " + success.getClientAddresses() );

                    log.debug( sb.toString() );
                }
                catch ( Exception e )
                {
                    // This is a monitor.  No exceptions should bubble up.
                    log.error( "Error in reply monitor", e );
                }
            }
        }

        next.execute( session, message );
    }


    protected String getContextKey()
    {
        return ( this.contextKey );
    }
}
