/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns;

import java.io.IOException;
import org.apache.directory.server.dns.protocol.DnsProtocolHandler;
import org.apache.directory.server.dns.store.jndi.JndiRecordStoreImpl;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.transport.socket.DatagramAcceptor;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsServer
extends DirectoryBackedService {
    private static final long serialVersionUID = 6943138644427163149L;
    private static final Logger LOG = LoggerFactory.getLogger((String)DnsServer.class.getName());
    private static final int DEFAULT_IP_PORT = 53;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.dns";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS DNS Service";

    public DnsServer() {
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
    }

    public void start() throws IOException {
        JndiRecordStoreImpl store = new JndiRecordStoreImpl(this.getSearchBaseDn(), this.getSearchBaseDn(), this.getDirectoryService());
        if (this.transports == null || this.transports.size() == 0) {
            UdpTransport transport = new UdpTransport(53);
            this.setTransports(new Transport[]{transport});
            DatagramAcceptor acceptor = transport.getAcceptor();
            acceptor.setHandler((IoHandler)new DnsProtocolHandler(this, store));
            ((DatagramSessionConfig)acceptor.getSessionConfig()).setReuseAddress(true);
            acceptor.bind();
        } else {
            for (Transport transport : this.transports) {
                IoAcceptor acceptor = transport.getAcceptor();
                acceptor.setHandler((IoHandler)new DnsProtocolHandler(this, store));
                if (transport instanceof UdpTransport) {
                    ((DatagramSessionConfig)acceptor.getSessionConfig()).setReuseAddress(true);
                } else {
                    acceptor.setCloseOnDeactivation(false);
                    ((NioSocketAcceptor)acceptor).setReuseAddress(true);
                    ((NioSocketAcceptor)acceptor).getSessionConfig().setTcpNoDelay(true);
                }
                acceptor.bind();
            }
        }
        LOG.info("DNS service started.");
        System.out.println("DNS service started.");
    }

    public void stop() {
        for (Transport transport : this.getTransports()) {
            IoAcceptor acceptor = transport.getAcceptor();
            if (acceptor == null) continue;
            acceptor.dispose();
        }
        LOG.info("DNS service stopped.");
        System.out.println("DNS service stopped.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DNSServer[").append(this.getServiceName()).append("], listening on :").append('\n');
        if (this.getTransports() != null) {
            for (Transport transport : this.getTransports()) {
                sb.append("    ").append(transport).append('\n');
            }
        }
        return sb.toString();
    }
}

