/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.directory.ldap.client.api.Krb5LoginConfiguration;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.AbstractKerberosITest;
import org.apache.directory.server.kerberos.kdc.KerberosTestUtils;
import org.apache.directory.server.ldap.handlers.sasl.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.plain.PlainMechanismHandler;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="SaslGssapiBindITest-class", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})}, additionalInterceptors={KeyDerivationInterceptor.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, saslHost="localhost", saslPrincipal="ldap/localhost@EXAMPLE.COM", saslMechanisms={@SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)})
@CreateKdcServer(transports={@CreateTransport(protocol="UDP", port=6088), @CreateTransport(protocol="TCP", port=6088)})
@ApplyLdifs(value={"dn: ou=users,dc=example,dc=com", "objectClass: top", "objectClass: organizationalUnit", "ou: users"})
public class SaslGssapiBindITest
extends AbstractKerberosITest {
    @Test
    public void testSaslGssapiBind() throws Exception {
        KerberosTestUtils.fixServicePrincipalName("ldap/" + KerberosTestUtils.getHostName() + "@EXAMPLE.COM", null, SaslGssapiBindITest.getLdapServer());
        AbstractKerberosITest.ObtainTicketParameters parameters = new AbstractKerberosITest.ObtainTicketParameters(this, TcpTransport.class, EncryptionType.AES128_CTS_HMAC_SHA1_96, ChecksumType.HMAC_SHA1_96_AES128);
        this.setupEnv(parameters);
        kdcServer.getConfig().setPaEncTimestampRequired(false);
        Configuration.setConfiguration((Configuration)new Krb5LoginConfiguration());
        LoginContext lc = null;
        try {
            lc = new LoginContext(SaslGssapiBindITest.class.getName(), new CallbackHandlerBean("hnelson", "secret"));
            lc.login();
        }
        catch (LoginException le) {
            Assert.fail((String)("Authentication failed:  " + le.getMessage()));
        }
        Subject.doAs(lc.getSubject(), new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    env.put("java.naming.provider.url", "ldap://" + KerberosTestUtils.getHostName() + ":" + AbstractLdapTestUnit.getLdapServer().getPort());
                    env.put("java.naming.security.authentication", "GSSAPI");
                    env.put("javax.security.sasl.qop", "auth-conf");
                    env.put("javax.security.sasl.server.authentication", "true");
                    env.put("javax.security.sasl.strength", "high");
                    InitialDirContext ctx = new InitialDirContext(env);
                    String[] attrIDs = new String[]{"uid"};
                    Attributes attrs = ctx.getAttributes("uid=hnelson,ou=users,dc=example,dc=com", attrIDs);
                    String uid = null;
                    if (attrs.get("uid") != null) {
                        uid = (String)attrs.get("uid").get();
                    }
                    Assert.assertEquals(uid, (Object)"hnelson");
                }
                catch (NamingException e) {
                    Assert.fail((String)("Should not have caught exception:  " + e.getMessage() + e.getRootCause()));
                }
                return null;
            }
        });
    }

    private class CallbackHandlerBean
    implements CallbackHandler {
        private String name;
        private String password;

        public CallbackHandlerBean(String name, String password) {
            this.name = name;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
            for (int ii = 0; ii < callbacks.length; ++ii) {
                Callback callBack = callbacks[ii];
                if (callBack instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callBack;
                    nameCallback.setName(this.name);
                    continue;
                }
                if (callBack instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callBack;
                    passwordCallback.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callBack, I18n.err((I18n)I18n.ERR_617, (Object[])new Object[0]));
            }
        }
    }
}

