/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.kerberos.kdc.AbstractKerberosITest;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="KerberosUdpIT-class", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com")}, additionalInterceptors={KeyDerivationInterceptor.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@CreateKdcServer(transports={@CreateTransport(protocol="TCP", port=6087), @CreateTransport(protocol="UDP", port=6087)})
@ApplyLdifFiles(value={"org/apache/directory/server/kerberos/kdc/KerberosIT.ldif"})
public class KerberosUdpITest
extends AbstractKerberosITest {
    @Test
    public void testObtainTickets_DES_CBC_MD5() throws Exception {
        if (System.getProperty("java.version").startsWith("1.8")) {
            return;
        }
        AbstractKerberosITest.ObtainTicketParameters parameters = new AbstractKerberosITest.ObtainTicketParameters(this, UdpTransport.class, EncryptionType.DES_CBC_MD5, ChecksumType.RSA_MD5);
        this.testObtainTickets(parameters);
    }

    @Test
    public void testObtainTickets_DES3_CBC_SHA1_KD() throws Exception {
        AbstractKerberosITest.ObtainTicketParameters parameters = new AbstractKerberosITest.ObtainTicketParameters(this, UdpTransport.class, EncryptionType.DES3_CBC_SHA1_KD, ChecksumType.HMAC_SHA1_DES3_KD);
        this.testObtainTickets(parameters);
    }

    @Test
    @Ignore(value="Fails with KrbException: Integrity check on decrypted field failed (31) - Integrity check on decrypted field failed")
    public void testObtainTickets_RC4_HMAC() throws Exception {
        AbstractKerberosITest.ObtainTicketParameters parameters = new AbstractKerberosITest.ObtainTicketParameters(this, UdpTransport.class, EncryptionType.RC4_HMAC, ChecksumType.HMAC_MD5);
        this.testObtainTickets(parameters);
    }

    @Test
    public void testObtainTickets_AES128() throws Exception {
        AbstractKerberosITest.ObtainTicketParameters parameters = new AbstractKerberosITest.ObtainTicketParameters(this, UdpTransport.class, EncryptionType.AES128_CTS_HMAC_SHA1_96, ChecksumType.HMAC_SHA1_96_AES128);
        this.testObtainTickets(parameters);
    }

    @Test
    @Ignore(value="Fails with javax.security.auth.login.LoginException: No supported encryption types listed in default_tkt_enctypes")
    public void testObtainTickets_AES256() throws Exception {
        AbstractKerberosITest.ObtainTicketParameters parameters = new AbstractKerberosITest.ObtainTicketParameters(this, UdpTransport.class, EncryptionType.AES256_CTS_HMAC_SHA1_96, ChecksumType.HMAC_SHA1_96_AES256);
        this.testObtainTickets(parameters);
    }
}

