/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.lang.SystemUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.LdapCoreSessionConnection;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.kerberos.kdc.KerberosTestUtils;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class AbstractKerberosITest
extends AbstractLdapTestUnit {
    public static final String USERS_DN = "ou=users,dc=example,dc=com";
    public static final String REALM = "EXAMPLE.COM";
    public static final String USER_UID = "hnelson";
    public static final String USER_PASSWORD = "secret";
    public static final String LDAP_SERVICE_NAME = "ldap";
    public static final String HOSTNAME = KerberosTestUtils.getHostName();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    protected LdapCoreSessionConnection conn;

    @Before
    public void setUp() throws Exception {
        this.conn = new LdapCoreSessionConnection(service);
        this.enableKerberosSchema();
    }

    @After
    public void tearDown() throws Exception {
        this.conn.close();
    }

    protected void testObtainTickets(ObtainTicketParameters parameters) throws Exception {
        this.setupEnv(parameters);
        Subject subject = new Subject();
        KerberosTestUtils.obtainTGT(subject, USER_UID, USER_PASSWORD);
        Assert.assertEquals((long)1L, (long)subject.getPrivateCredentials().size());
        Assert.assertEquals((long)0L, (long)subject.getPublicCredentials().size());
        KerberosTestUtils.obtainServiceTickets(subject, USER_UID, LDAP_SERVICE_NAME, HOSTNAME);
        Assert.assertEquals((long)2L, (long)subject.getPrivateCredentials().size());
        Assert.assertEquals((long)0L, (long)subject.getPublicCredentials().size());
        for (KerberosTicket kt : subject.getPrivateCredentials(KerberosTicket.class)) {
            Assert.assertEquals((long)parameters.encryptionType.getValue(), (long)kt.getSessionKeyType());
        }
    }

    private void enableKerberosSchema() throws LdapException {
        DefaultModification mod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "m-disabled", new String[]{"FALSE"});
        this.conn.modify("cn=Krb5kdc,ou=schema", new Modification[]{mod});
    }

    protected void setupEnv(ObtainTicketParameters parameters) throws Exception {
        String krb5confPath = this.createKrb5Conf(parameters.checksumType, parameters.encryptionType, parameters.transport == TcpTransport.class);
        System.setProperty("java.security.krb5.conf", krb5confPath);
        kdcServer.getConfig().setEncryptionTypes(Collections.singleton(parameters.encryptionType));
        this.createPrincipal("uid=hnelson", "Last", "First Last", USER_UID, USER_PASSWORD, "hnelson@EXAMPLE.COM");
        this.createPrincipal("uid=krbtgt", "KDC Service", "KDC Service", "krbtgt", USER_PASSWORD, "krbtgt/EXAMPLE.COM@EXAMPLE.COM");
        String servicePrincipal = "ldap/" + HOSTNAME + "@" + REALM;
        this.createPrincipal("uid=ldap", "Service", "LDAP Service", LDAP_SERVICE_NAME, "randall", servicePrincipal);
    }

    private String createKrb5Conf(ChecksumType checksumType, EncryptionType encryptionType, boolean isTcp) throws IOException {
        File file = this.folder.newFile("krb5.conf");
        String data = "";
        data = data + "[libdefaults]" + SystemUtils.LINE_SEPARATOR;
        data = data + "default_realm = EXAMPLE.COM" + SystemUtils.LINE_SEPARATOR;
        data = data + "default_tkt_enctypes = " + encryptionType.getName() + SystemUtils.LINE_SEPARATOR;
        data = data + "default_tgs_enctypes = " + encryptionType.getName() + SystemUtils.LINE_SEPARATOR;
        data = data + "permitted_enctypes = " + encryptionType.getName() + SystemUtils.LINE_SEPARATOR;
        data = data + "default-checksum_type = " + checksumType.getName() + SystemUtils.LINE_SEPARATOR;
        if (isTcp) {
            data = data + "udp_preference_limit = 1" + SystemUtils.LINE_SEPARATOR;
        }
        data = data + "[realms]" + SystemUtils.LINE_SEPARATOR;
        data = data + "EXAMPLE.COM = {" + SystemUtils.LINE_SEPARATOR;
        data = data + "kdc = " + HOSTNAME + ":" + kdcServer.getTransports()[0].getPort() + SystemUtils.LINE_SEPARATOR;
        data = data + "}" + SystemUtils.LINE_SEPARATOR;
        data = data + "[domain_realm]" + SystemUtils.LINE_SEPARATOR;
        data = data + "." + Strings.toLowerCaseAscii((String)REALM) + " = " + REALM + SystemUtils.LINE_SEPARATOR;
        data = data + Strings.toLowerCaseAscii((String)REALM) + " = " + REALM + SystemUtils.LINE_SEPARATOR;
        FileUtils.writeStringToFile((File)file, (String)data);
        return file.getAbsolutePath();
    }

    private void createPrincipal(String rdn, String sn, String cn, String uid, String userPassword, String principalName) throws LdapException {
        DefaultEntry entry = new DefaultEntry();
        entry.setDn(rdn + "," + USERS_DN);
        entry.add("objectClass", new String[]{"top", "person", "inetOrgPerson", "krb5principal", "krb5kdcentry"});
        entry.add("cn", new String[]{cn});
        entry.add("sn", new String[]{sn});
        entry.add("uid", new String[]{uid});
        entry.add("userPassword", new String[]{userPassword});
        entry.add("krb5PrincipalName", new String[]{principalName});
        entry.add("krb5KeyVersionNumber", new String[]{"0"});
        this.conn.add((Entry)entry);
    }

    class ObtainTicketParameters {
        Class<? extends Transport> transport;
        EncryptionType encryptionType;
        ChecksumType checksumType;
        Integer oldUdpPrefLimit;
        Integer oldCksumtypeDefault;

        public ObtainTicketParameters(Class<? extends Transport> transport, EncryptionType encryptionType, ChecksumType checksumType) {
            this.transport = transport;
            this.encryptionType = encryptionType;
            this.checksumType = checksumType;
        }
    }
}

