/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import jdbm.recman.TransactionManager;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.ParentIdAndRdnSerializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.UuidSerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.ParentIdAndRdnComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmRdnIndex
extends JdbmIndex<ParentIdAndRdn> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmRdnIndex.class);

    public JdbmRdnIndex() {
        super("1.3.6.1.4.1.18060.0.4.1.2.50", true);
        this.initialized = false;
    }

    @Override
    public void init(SchemaManager schemaManager, AttributeType attributeType) throws IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            NullPointerException e = new NullPointerException("The index working directory has not be set");
            throw e;
        }
        String path = new File(this.wkDirPath, attributeType.getOid()).getAbsolutePath();
        BaseRecordManager base = new BaseRecordManager(path);
        TransactionManager transactionManager = base.getTransactionManager();
        transactionManager.setMaximumTransactionsInLog(2000);
        this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(this.cacheSize));
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        FileWriter fw = new FileWriter(new File(path + "-" + attributeType.getName() + ".txt"));
        fw.write(attributeType.toString());
        fw.close();
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_574, (Object[])new Object[]{this.attributeType.getName()}));
        }
        ParentIdAndRdnComparator comp = new ParentIdAndRdnComparator(mr.getOid());
        UuidComparator.INSTANCE.setSchemaManager(schemaManager);
        ParentIdAndRdnSerializer parentIdAndSerializer = new ParentIdAndRdnSerializer(schemaManager);
        this.forward = new JdbmTable(schemaManager, this.attributeType.getOid() + "_forward", this.recMan, comp, parentIdAndSerializer, UuidSerializer.INSTANCE);
        this.reverse = new JdbmTable(schemaManager, this.attributeType.getOid() + "_reverse", this.recMan, UuidComparator.INSTANCE, UuidSerializer.INSTANCE, parentIdAndSerializer);
    }
}

