/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import jdbm.I18n;
import jdbm.btree.BTree;
import jdbm.helper.ActionContext;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;

public class BPage<K, V>
implements Serializer {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    transient BTree<K, V> btree;
    protected transient long recordId;
    protected boolean isLeaf;
    protected K[] keys;
    protected V[] values;
    protected long[] children;
    protected int first;
    protected long previous;
    protected long next;
    public static AtomicInteger outstandingBrowsers = new AtomicInteger(0);

    public BPage() {
    }

    BPage(BTree<K, V> btree, BPage<K, V> root, BPage<K, V> overflow) throws IOException {
        this.btree = btree;
        this.isLeaf = false;
        this.first = btree.pageSize - 2;
        this.keys = new Object[btree.pageSize];
        this.keys[btree.pageSize - 2] = overflow.getLargestKey();
        this.keys[btree.pageSize - 1] = root.getLargestKey();
        this.children = new long[btree.pageSize];
        this.children[btree.pageSize - 2] = overflow.recordId;
        this.children[btree.pageSize - 1] = root.recordId;
        this.recordId = btree.recordManager.insert(this, this);
    }

    BPage(BTree<K, V> btree, K key, V value) throws IOException {
        this.btree = btree;
        this.isLeaf = true;
        this.first = btree.pageSize - 2;
        this.keys = new Object[btree.pageSize];
        this.keys[btree.pageSize - 2] = key;
        this.keys[btree.pageSize - 1] = null;
        this.values = new Object[btree.pageSize];
        this.values[btree.pageSize - 2] = btree.copyValue(value);
        this.values[btree.pageSize - 1] = null;
        this.recordId = btree.recordManager.insert(this, this);
    }

    BPage(BTree btree, boolean isLeaf) throws IOException {
        this.btree = btree;
        this.isLeaf = isLeaf;
        this.first = btree.pageSize / 2;
        this.keys = new Object[btree.pageSize];
        if (isLeaf) {
            this.values = new Object[btree.pageSize];
        } else {
            this.children = new long[btree.pageSize];
        }
        this.recordId = btree.recordManager.insert(this, this);
    }

    BPage<K, V> copyOnWrite() {
        BPage<K, V> newPage = new BPage<K, V>();
        newPage.btree = this.btree;
        newPage.isLeaf = this.isLeaf;
        newPage.first = this.first;
        newPage.previous = this.previous;
        newPage.next = this.next;
        newPage.keys = new Object[this.btree.pageSize];
        newPage.values = new Object[this.btree.pageSize];
        newPage.children = new long[this.btree.pageSize];
        newPage.recordId = this.recordId;
        if (this.children != null) {
            this.copyChildren(this, 0, newPage, 0, this.btree.pageSize);
        }
        if (this.values != null) {
            this.copyEntries(this, 0, newPage, 0, this.btree.pageSize);
        }
        return newPage;
    }

    K getLargestKey() {
        return this.keys[this.btree.pageSize - 1];
    }

    public long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    boolean isEmpty() {
        if (this.isLeaf) {
            return this.first == this.values.length - 1;
        }
        return this.first == this.children.length - 1;
    }

    boolean isFull() {
        return this.first == 0;
    }

    TupleBrowser<K, V> find(int height, K key, ActionContext context) throws IOException {
        int index = this.findChildren(key);
        if (index < 0) {
            index = -(index + 1);
        }
        BPage<K, V> child = this;
        while (!child.isLeaf) {
            if ((index = super.findChildren(key)) >= 0) continue;
            index = -(index + 1);
        }
        return new Browser(child, index, context);
    }

    TupleBrowser<K, V> findFirst(ActionContext context) throws IOException {
        if (this.isLeaf) {
            return new Browser(this, this.first, context);
        }
        BPage<K, V> child = this.childBPage(this.first);
        return child.findFirst(context);
    }

    InsertResult<K, V> insert(int height, K key, V value, boolean replace) throws IOException {
        long overflow;
        InsertResult result;
        boolean keyExists;
        int index = this.findChildren(key);
        boolean bl = keyExists = index < 0;
        if (index < 0) {
            index = -(index + 1);
        }
        BPage<K, V> pageNewCopy = null;
        if (--height == 0) {
            pageNewCopy = this.btree.copyOnWrite(this);
            result = new InsertResult();
            result.pageNewCopy = pageNewCopy;
            overflow = -1L;
            if (keyExists) {
                result.existing = this.values[index];
                if (replace) {
                    pageNewCopy.values[index] = this.btree.copyValue(value);
                    this.btree.recordManager.update(this.recordId, pageNewCopy, this);
                }
                return result;
            }
        } else {
            BPage<K, V> child = this.childBPage(index);
            result = child.insert(height, key, value, replace);
            if (result.pageNewCopy != null) {
                child = result.pageNewCopy;
                result.pageNewCopy = null;
            }
            if (result.existing != null) {
                return result;
            }
            if (result.overflow == null) {
                return result;
            }
            pageNewCopy = this.btree.copyOnWrite(this);
            result.pageNewCopy = pageNewCopy;
            key = result.overflow.getLargestKey();
            overflow = result.overflow.recordId;
            pageNewCopy.keys[index] = child.getLargestKey();
            result.overflow = null;
        }
        if (!pageNewCopy.isFull()) {
            if (height == 0) {
                this.insertEntry(pageNewCopy, index - 1, key, value);
            } else {
                this.insertChild(pageNewCopy, index - 1, key, overflow);
            }
            this.btree.recordManager.update(this.recordId, pageNewCopy, this);
            return result;
        }
        int half = this.btree.pageSize >> 1;
        BPage<K, V> newPage = new BPage<K, V>(this.btree, pageNewCopy.isLeaf);
        if (index < half) {
            if (height == 0) {
                this.copyEntries(pageNewCopy, 0, newPage, half, index);
                this.setEntry(newPage, half + index, key, value);
                this.copyEntries(pageNewCopy, index, newPage, half + index + 1, half - index - 1);
            } else {
                this.copyChildren(pageNewCopy, 0, newPage, half, index);
                this.setChild(newPage, half + index, key, overflow);
                this.copyChildren(pageNewCopy, index, newPage, half + index + 1, half - index - 1);
            }
        } else if (height == 0) {
            this.copyEntries(pageNewCopy, 0, newPage, half, half);
            this.copyEntries(pageNewCopy, half, pageNewCopy, half - 1, index - half);
            this.setEntry(pageNewCopy, index - 1, key, value);
        } else {
            this.copyChildren(pageNewCopy, 0, newPage, half, half);
            this.copyChildren(pageNewCopy, half, pageNewCopy, half - 1, index - half);
            this.setChild(pageNewCopy, index - 1, key, overflow);
        }
        pageNewCopy.first = half - 1;
        for (int i = 0; i < pageNewCopy.first; ++i) {
            if (height == 0) {
                this.setEntry(pageNewCopy, i, null, null);
                continue;
            }
            this.setChild(pageNewCopy, i, null, -1L);
        }
        if (pageNewCopy.isLeaf) {
            newPage.previous = pageNewCopy.previous;
            newPage.next = pageNewCopy.recordId;
            if (pageNewCopy.previous != 0L) {
                BPage<K, V> previousBPage = this.loadBPage(pageNewCopy.previous);
                previousBPage = this.btree.copyOnWrite(previousBPage);
                previousBPage.next = newPage.recordId;
                this.btree.recordManager.update(pageNewCopy.previous, previousBPage, this);
            }
            pageNewCopy.previous = newPage.recordId;
        }
        this.btree.recordManager.update(this.recordId, pageNewCopy, this);
        this.btree.recordManager.update(newPage.recordId, newPage, this);
        result.overflow = newPage;
        return result;
    }

    RemoveResult<K, V> remove(int height, K key) throws IOException {
        RemoveResult result;
        boolean keyExists;
        int half = this.btree.pageSize / 2;
        int index = this.findChildren(key);
        boolean bl = keyExists = index < 0;
        if (index < 0) {
            index = -(index + 1);
        }
        BPage<K, V> pageNewCopy = this.btree.copyOnWrite(this);
        if (--height == 0) {
            if (!keyExists) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_514, key));
            }
            result = new RemoveResult();
            result.value = pageNewCopy.values[index];
            this.removeEntry(pageNewCopy, index);
            this.btree.recordManager.update(this.recordId, pageNewCopy, this);
        } else {
            BPage<K, V> child = this.childBPage(index);
            result = child.remove(height, key);
            if (result.pageNewCopy != null) {
                child = result.pageNewCopy;
                result.pageNewCopy = null;
            } else {
                child = this.btree.copyOnWrite(child);
            }
            pageNewCopy.keys[index] = child.getLargestKey();
            this.btree.recordManager.update(this.recordId, pageNewCopy, this);
            if (result.underflow) {
                if (child.first != half + 1) {
                    throw new IllegalStateException(I18n.err(I18n.ERR_513, "1"));
                }
                if (index < pageNewCopy.children.length - 1) {
                    BPage<K, V> brother = pageNewCopy.childBPage(index + 1);
                    brother = this.btree.copyOnWrite(brother);
                    int bfirst = brother.first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother.first += steal;
                        child.first -= steal;
                        if (child.isLeaf) {
                            this.copyEntries(child, half + 1, child, half + 1 - steal, half - 1);
                            this.copyEntries(brother, bfirst, child, 2 * half - steal, steal);
                        } else {
                            this.copyChildren(child, half + 1, child, half + 1 - steal, half - 1);
                            this.copyChildren(brother, bfirst, child, 2 * half - steal, steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother.isLeaf) {
                                this.setEntry(brother, i, null, null);
                                continue;
                            }
                            this.setChild(brother, i, null, -1L);
                        }
                        pageNewCopy.keys[index] = child.getLargestKey();
                        this.btree.recordManager.update(this.recordId, pageNewCopy, this);
                        this.btree.recordManager.update(brother.recordId, brother, this);
                        this.btree.recordManager.update(child.recordId, child, this);
                    } else {
                        if (brother.first != half) {
                            throw new IllegalStateException(I18n.err(I18n.ERR_513, "2"));
                        }
                        brother.first = 1;
                        if (child.isLeaf) {
                            this.copyEntries(child, half + 1, brother, 1, half - 1);
                        } else {
                            this.copyChildren(child, half + 1, brother, 1, half - 1);
                        }
                        this.btree.recordManager.update(brother.recordId, brother, this);
                        if (pageNewCopy.isLeaf) {
                            this.copyEntries(pageNewCopy, pageNewCopy.first, pageNewCopy, pageNewCopy.first + 1, index - pageNewCopy.first);
                            this.setEntry(pageNewCopy, pageNewCopy.first, null, null);
                        } else {
                            this.copyChildren(pageNewCopy, pageNewCopy.first, pageNewCopy, pageNewCopy.first + 1, index - pageNewCopy.first);
                            this.setChild(pageNewCopy, pageNewCopy.first, null, -1L);
                        }
                        ++pageNewCopy.first;
                        this.btree.recordManager.update(this.recordId, pageNewCopy, this);
                        if (child.previous != 0L) {
                            BPage<K, V> prev = this.loadBPage(child.previous);
                            prev = this.btree.copyOnWrite(prev);
                            prev.next = child.next;
                            this.btree.recordManager.update(prev.recordId, prev, this);
                        }
                        if (child.next != 0L) {
                            BPage<K, V> next = this.loadBPage(child.next);
                            next = this.btree.copyOnWrite(next);
                            next.previous = child.previous;
                            this.btree.recordManager.update(next.recordId, next, this);
                        }
                        this.btree.recordManager.delete(child.recordId);
                    }
                } else {
                    BPage<K, V> brother = pageNewCopy.childBPage(index - 1);
                    brother = this.btree.copyOnWrite(brother);
                    int bfirst = brother.first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother.first += steal;
                        child.first -= steal;
                        if (child.isLeaf) {
                            this.copyEntries(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            this.copyEntries(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        } else {
                            this.copyChildren(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            this.copyChildren(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother.isLeaf) {
                                this.setEntry(brother, i, null, null);
                                continue;
                            }
                            this.setChild(brother, i, null, -1L);
                        }
                        pageNewCopy.keys[index - 1] = brother.getLargestKey();
                        this.btree.recordManager.update(this.recordId, pageNewCopy, this);
                        this.btree.recordManager.update(brother.recordId, brother, this);
                        this.btree.recordManager.update(child.recordId, child, this);
                    } else {
                        if (brother.first != half) {
                            throw new IllegalStateException(I18n.err(I18n.ERR_513, "3"));
                        }
                        child.first = 1;
                        if (child.isLeaf) {
                            this.copyEntries(brother, half, child, 1, half);
                        } else {
                            this.copyChildren(brother, half, child, 1, half);
                        }
                        this.btree.recordManager.update(child.recordId, child, this);
                        if (pageNewCopy.isLeaf) {
                            this.copyEntries(pageNewCopy, pageNewCopy.first, pageNewCopy, pageNewCopy.first + 1, index - 1 - pageNewCopy.first);
                            this.setEntry(pageNewCopy, pageNewCopy.first, null, null);
                        } else {
                            this.copyChildren(pageNewCopy, pageNewCopy.first, pageNewCopy, pageNewCopy.first + 1, index - 1 - pageNewCopy.first);
                            this.setChild(pageNewCopy, pageNewCopy.first, null, -1L);
                        }
                        ++pageNewCopy.first;
                        this.btree.recordManager.update(this.recordId, pageNewCopy, this);
                        if (brother.previous != 0L) {
                            BPage<K, V> prev = this.loadBPage(brother.previous);
                            prev = this.btree.copyOnWrite(prev);
                            prev.next = brother.next;
                            this.btree.recordManager.update(prev.recordId, prev, this);
                        }
                        if (brother.next != 0L) {
                            BPage<K, V> next = this.loadBPage(brother.next);
                            next = this.btree.copyOnWrite(next);
                            next.previous = brother.previous;
                            this.btree.recordManager.update(next.recordId, next, this);
                        }
                        this.btree.recordManager.delete(brother.recordId);
                    }
                }
            }
        }
        result.underflow = pageNewCopy.first > half;
        result.pageNewCopy = pageNewCopy;
        return result;
    }

    private int findChildren(K key) {
        int left = this.first;
        int right = this.btree.pageSize - 1;
        while (left < right) {
            int middle = left + right >>> 1;
            int comp = this.compare(this.keys[middle], key);
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            if (comp > 0) {
                right = middle;
                continue;
            }
            return -middle - 1;
        }
        if (left == right && this.compare(this.keys[left], key) == 0) {
            return -right - 1;
        }
        return right;
    }

    private void insertEntry(BPage<K, V> page, int index, K key, V value) throws IOException {
        K[] keys = page.keys;
        V[] values = page.values;
        int start = page.first;
        int count = index - page.first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(values, start, values, start - 1, count);
        --page.first;
        keys[index] = key;
        values[index] = this.btree.copyValue(value);
    }

    private void insertChild(BPage<K, V> page, int index, K key, long child) {
        K[] keys = page.keys;
        long[] children = page.children;
        int start = page.first;
        int count = index - page.first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(children, start, children, start - 1, count);
        --page.first;
        keys[index] = key;
        children[index] = child;
    }

    private void removeEntry(BPage<K, V> page, int index) {
        K[] keys = page.keys;
        V[] values = page.values;
        int start = page.first;
        int count = index - page.first;
        System.arraycopy(keys, start, keys, start + 1, count);
        keys[start] = null;
        System.arraycopy(values, start, values, start + 1, count);
        values[start] = null;
        ++page.first;
    }

    private void setEntry(BPage<K, V> page, int index, K key, V value) throws IOException {
        page.keys[index] = key;
        page.values[index] = this.btree.copyValue(value);
    }

    private void setChild(BPage<K, V> page, int index, K key, long recid) {
        page.keys[index] = key;
        page.children[index] = recid;
    }

    private void copyEntries(BPage<K, V> source, int indexSource, BPage<K, V> dest, int indexDest, int count) {
        System.arraycopy(source.keys, indexSource, dest.keys, indexDest, count);
        System.arraycopy(source.values, indexSource, dest.values, indexDest, count);
    }

    private void copyChildren(BPage<K, V> source, int indexSource, BPage<K, V> dest, int indexDest, int count) {
        System.arraycopy(source.keys, indexSource, dest.keys, indexDest, count);
        System.arraycopy(source.children, indexSource, dest.children, indexDest, count);
    }

    BPage<K, V> childBPage(int index) throws IOException {
        return this.loadBPage(this.children[index]);
    }

    private BPage<K, V> loadBPage(long recid) throws IOException {
        BPage child = (BPage)this.btree.recordManager.fetch(recid, this);
        child.recordId = recid;
        child.btree = this.btree;
        return child;
    }

    private final int compare(K value1, K value2) {
        if (value1 == value2) {
            return 0;
        }
        if (value1 == null) {
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        return this.btree.getComparator().compare(value1, value2);
    }

    static byte[] readByteArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] buf = new byte[len];
        in.readFully(buf);
        return buf;
    }

    static void writeByteArray(ObjectOutput out, byte[] buf) throws IOException {
        if (buf == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(buf.length);
            out.write(buf);
        }
    }

    private void dump(int height) {
        int i;
        StringBuffer prefix = new StringBuffer();
        for (i = 0; i < height; ++i) {
            prefix.append("    ");
        }
        System.out.println(prefix + "-------------------------------------- BPage recordId=" + this.recordId);
        System.out.println(prefix + "first=" + this.first);
        for (i = 0; i < this.btree.pageSize; ++i) {
            if (this.isLeaf) {
                System.out.println(prefix + "BPage [" + i + "] " + this.keys[i] + " " + this.values[i]);
                continue;
            }
            System.out.println(prefix + "BPage [" + i + "] " + this.keys[i] + " " + this.children[i]);
        }
        System.out.println(prefix + "--------------------------------------");
    }

    void dumpRecursive(int height, int level) throws IOException {
        ++level;
        if (--height > 0) {
            for (int i = this.first; i < this.btree.pageSize && this.keys[i] != null; ++i) {
                BPage<K, V> child = this.childBPage(i);
                super.dump(level);
                child.dumpRecursive(height, level);
            }
        }
    }

    private void assertConsistency() {
        for (int i = this.first; i < this.btree.pageSize - 1; ++i) {
            if (this.compare(this.keys[i], this.keys[i + 1]) < 0) continue;
            this.dump(0);
            throw new Error(I18n.err(I18n.ERR_515, new Object[0]));
        }
    }

    void assertConsistencyRecursive(int height) throws IOException {
        this.assertConsistency();
        if (--height > 0) {
            for (int i = this.first; i < this.btree.pageSize && this.keys[i] != null; ++i) {
                BPage<K, V> child = this.childBPage(i);
                if (this.compare(this.keys[i], child.getLargestKey()) != 0) {
                    this.dump(0);
                    super.dump(0);
                    throw new Error(I18n.err(I18n.ERR_516, new Object[0]));
                }
                child.assertConsistencyRecursive(height);
            }
        }
    }

    @Override
    public BPage<K, V> deserialize(byte[] serialized) throws IOException {
        int i;
        BPage<K, V> bpage = new BPage<K, V>();
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        ObjectInputStream ois = new ObjectInputStream(bais);
        bpage.isLeaf = ois.readBoolean();
        if (bpage.isLeaf) {
            bpage.previous = ois.readLong();
            bpage.next = ois.readLong();
        }
        bpage.first = ois.readInt();
        bpage.keys = new Object[this.btree.pageSize];
        try {
            for (i = bpage.first; i < this.btree.pageSize; ++i) {
                if (this.btree.keySerializer == null) {
                    bpage.keys[i] = ois.readObject();
                    continue;
                }
                serialized = BPage.readByteArray(ois);
                if (serialized == null) continue;
                bpage.keys[i] = this.btree.keySerializer.deserialize(serialized);
            }
        }
        catch (ClassNotFoundException except) {
            throw new IOException(except.getLocalizedMessage());
        }
        if (bpage.isLeaf) {
            bpage.values = new Object[this.btree.pageSize];
            try {
                for (i = bpage.first; i < this.btree.pageSize; ++i) {
                    if (this.btree.valueSerializer == null) {
                        bpage.values[i] = ois.readObject();
                        continue;
                    }
                    serialized = BPage.readByteArray(ois);
                    if (serialized == null) continue;
                    bpage.values[i] = this.btree.valueSerializer.deserialize(serialized);
                }
            }
            catch (ClassNotFoundException except) {
                throw new IOException(except.getLocalizedMessage());
            }
        } else {
            bpage.children = new long[this.btree.pageSize];
            for (i = bpage.first; i < this.btree.pageSize; ++i) {
                bpage.children[i] = ois.readLong();
            }
        }
        ois.close();
        bais.close();
        return bpage;
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        byte[] serialized;
        int i;
        BPage bpage = (BPage)obj;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeBoolean(bpage.isLeaf);
        if (bpage.isLeaf) {
            oos.writeLong(bpage.previous);
            oos.writeLong(bpage.next);
        }
        oos.writeInt(bpage.first);
        for (i = bpage.first; i < this.btree.pageSize; ++i) {
            if (this.btree.keySerializer == null) {
                oos.writeObject(bpage.keys[i]);
                continue;
            }
            if (bpage.keys[i] != null) {
                serialized = this.btree.keySerializer.serialize(bpage.keys[i]);
                BPage.writeByteArray(oos, serialized);
                continue;
            }
            BPage.writeByteArray(oos, null);
        }
        if (bpage.isLeaf) {
            for (i = bpage.first; i < this.btree.pageSize; ++i) {
                if (this.btree.valueSerializer == null) {
                    oos.writeObject(bpage.values[i]);
                    continue;
                }
                if (bpage.values[i] != null) {
                    serialized = this.btree.valueSerializer.serialize(bpage.values[i]);
                    BPage.writeByteArray(oos, serialized);
                    continue;
                }
                BPage.writeByteArray(oos, null);
            }
        } else {
            for (i = bpage.first; i < this.btree.pageSize; ++i) {
                oos.writeLong(bpage.children[i]);
            }
        }
        oos.flush();
        byte[] data = baos.toByteArray();
        oos.close();
        baos.close();
        return data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isLeaf) {
            sb.append("Leaf(");
        } else {
            sb.append("Node(");
        }
        sb.append(this.keys.length);
        sb.append(") : [");
        if (this.isLeaf) {
            boolean isFirst = true;
            int index = 0;
            for (K key : this.keys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<");
                sb.append(String.valueOf(key));
                sb.append("/");
                sb.append(this.values[index]);
                sb.append(">");
                ++index;
            }
        } else {
            boolean isFirst = true;
            for (K key : this.keys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<");
                sb.append(key);
                sb.append(">");
            }
        }
        sb.append("]\n");
        return sb.toString();
    }

    class Browser
    extends TupleBrowser<K, V> {
        private BPage<K, V> page;
        ActionContext context;
        private int index;

        Browser(BPage<K, V> page, int index, ActionContext context) {
            this.page = page;
            this.index = index;
            this.context = context;
            outstandingBrowsers.incrementAndGet();
        }

        @Override
        public boolean getNext(Tuple<K, V> tuple) throws IOException {
            BPage.this.btree.setAsCurrentAction(this.context);
            try {
                if (this.index < this.page.btree.pageSize) {
                    if (this.page.keys[this.index] == null) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (this.page.next != 0L) {
                    this.page = this.page.loadBPage(this.page.next);
                    this.index = this.page.first;
                }
                tuple.setKey(this.page.keys[this.index]);
                tuple.setValue(BPage.this.btree.copyValue(this.page.values[this.index]));
                ++this.index;
            }
            catch (IOException e) {
                BPage.this.btree.abortAction(this.context);
                this.context = null;
                this.close();
                throw e;
            }
            finally {
                if (this.context != null) {
                    BPage.this.btree.unsetAsCurrentAction(this.context);
                }
            }
            return true;
        }

        @Override
        public boolean getPrevious(Tuple<K, V> tuple) throws IOException {
            BPage.this.btree.setAsCurrentAction(this.context);
            try {
                if (this.index == this.page.first) {
                    if (this.page.previous != 0L) {
                        this.page = this.page.loadBPage(this.page.previous);
                        this.index = this.page.btree.pageSize;
                    } else {
                        boolean bl = false;
                        return bl;
                    }
                }
                --this.index;
                tuple.setKey(this.page.keys[this.index]);
                tuple.setValue(BPage.this.btree.copyValue(this.page.values[this.index]));
            }
            catch (IOException e) {
                BPage.this.btree.abortAction(this.context);
                this.context = null;
                this.close();
                throw e;
            }
            finally {
                if (this.context != null) {
                    BPage.this.btree.unsetAsCurrentAction(this.context);
                }
            }
            return true;
        }

        @Override
        public void close() {
            int browserCount;
            super.close();
            if (this.context != null) {
                BPage.this.btree.setAsCurrentAction(this.context);
                BPage.this.btree.endAction(this.context);
                this.context = null;
            }
            if ((browserCount = outstandingBrowsers.decrementAndGet()) > 0) {
                // empty if block
            }
        }
    }

    static class RemoveResult<K, V> {
        boolean underflow;
        V value;
        BPage<K, V> pageNewCopy;

        RemoveResult() {
        }
    }

    static class InsertResult<K, V> {
        BPage<K, V> overflow;
        V existing;
        BPage<K, V> pageNewCopy;

        InsertResult() {
        }
    }
}

