/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

public final class Chars {
    public static final boolean[] ALPHA = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] ALPHA_LOWER_CASE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] ALPHA_UPPER_CASE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final boolean[] ALPHA_DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final boolean[] HEX = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public static boolean isCharASCII(char[] chars, int index, char car) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] == car;
    }

    public static boolean isCharASCII(String string, int index, char car) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        return string.charAt(index) == car;
    }

    public static boolean isICharASCII(String string, int index, char car) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        return ((string.charAt(index) | 0x20) & car) == car;
    }

    public static boolean isICharASCII(byte[] bytes, int index, char car) {
        if (bytes == null) {
            return false;
        }
        int length = bytes.length;
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        return ((bytes[index] | 0x20) & car) == car;
    }

    public static boolean isAlpha(byte c) {
        return c > 0 && c <= 127 && ALPHA[c];
    }

    public static boolean isAlpha(char c) {
        return c > '\u0000' && c <= '\u007f' && ALPHA[c];
    }

    public static boolean isAlphaASCII(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return (c | 0x7F) == 127 && ALPHA[c];
    }

    public static boolean isAlphaASCII(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        char c = chars[index];
        return c <= '\u007f' && ALPHA[c];
    }

    public static boolean isAlphaASCII(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && ALPHA[c];
    }

    public static boolean isAlphaLowercaseASCII(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && ALPHA_LOWER_CASE[c];
    }

    public static boolean isAlphaUppercaseASCII(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && ALPHA_UPPER_CASE[c];
    }

    public static boolean isAlphaDigit(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && ALPHA_DIGIT[c];
    }

    public static boolean isAlphaDigitMinus(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return (c | 0x7F) == 127 && CHAR[c];
    }

    public static boolean isAlphaDigitMinus(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        char c = chars[index];
        return c <= '\u007f' && CHAR[c];
    }

    public static boolean isAlphaDigitMinus(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && CHAR[c];
    }

    public static boolean isAlphaDigitMinus(char c) {
        return (c & 0x7F) == c && CHAR[c];
    }

    public static boolean isBit(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c == '0' || c == '1';
    }

    public static boolean isDigit(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        return (bytes[0] | 0x7F) == 127 && DIGIT[bytes[0]];
    }

    public static boolean isDigit(char car) {
        return car >= '0' && car <= '9';
    }

    public static boolean isDigit(byte car) {
        return car >= 48 && car <= 57;
    }

    public static boolean isDigit(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        return (bytes[index] | 0x7F) == 127 && DIGIT[bytes[index]];
    }

    public static boolean isDigit(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] <= '\u007f' && DIGIT[chars[index]];
    }

    public static boolean isDigit(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && DIGIT[c];
    }

    public static boolean isDigit(char[] chars) {
        if (chars == null || chars.length == 0) {
            return false;
        }
        return chars[0] <= '\u007f' && DIGIT[chars[0]];
    }

    public static boolean isHex(char c) {
        return (c | 0x7F) == 127 && HEX[c];
    }

    public static boolean isHex(byte b) {
        return (b | 0x7F) == 127 && HEX[b];
    }

    public static boolean isHex(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return (c | 0x7F) == 127 && HEX[c];
    }

    public static boolean isHex(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        char c = chars[index];
        return (c | 0x7F) == 127 && HEX[c];
    }

    public static boolean isHex(String string, int index) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        if (length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return (c | 0x7F) == 127 && HEX[c];
    }

    public static boolean isUnderscore(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return c == 95;
    }
}

