/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import java.util.Observable;
import java.util.Observer;
import org.apache.directory.api.ldap.model.message.AbandonListener;
import org.apache.directory.api.ldap.model.message.AbandonableRequest;
import org.apache.directory.api.ldap.model.message.AbstractRequest;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;

public abstract class AbstractAbandonableRequest
extends AbstractRequest
implements AbandonableRequest {
    private boolean abandoned = false;
    private RequestObservable observable;

    protected AbstractAbandonableRequest(int id, MessageTypeEnum type) {
        super(id, type, true);
    }

    @Override
    public void abandon() {
        if (this.abandoned) {
            return;
        }
        this.abandoned = true;
        if (this.observable == null) {
            this.observable = new RequestObservable();
        }
        this.observable.setChanged();
        this.observable.notifyObservers();
        this.observable.deleteObservers();
    }

    @Override
    public boolean isAbandoned() {
        return this.abandoned;
    }

    @Override
    public AbandonableRequest addAbandonListener(final AbandonListener listener) {
        if (this.observable == null) {
            this.observable = new RequestObservable();
        }
        this.observable.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                listener.requestAbandoned(AbstractAbandonableRequest.this);
            }
        });
        return this;
    }

    static class RequestObservable
    extends Observable {
        RequestObservable() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }
}

