/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyResponseContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyRequest;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyRequestImpl;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponse;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponseImpl;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class PasswordModifyFactory
implements ExtendedOperationFactory {
    private LdapApiService codec;

    public PasswordModifyFactory(LdapApiService codec) {
        this.codec = codec;
    }

    public String getOid() {
        return "1.3.6.1.4.1.4203.1.11.1";
    }

    public PasswordModifyResponse newResponse(byte[] encodedValue) throws DecoderException {
        PasswordModifyResponseDecorator response = new PasswordModifyResponseDecorator(this.codec, (PasswordModifyResponse)new PasswordModifyResponseImpl());
        response.setResponseValue(encodedValue);
        return response;
    }

    public PasswordModifyRequest newRequest(byte[] value) {
        PasswordModifyRequestDecorator req = new PasswordModifyRequestDecorator(this.codec, (PasswordModifyRequest)new PasswordModifyRequestImpl());
        if (value != null) {
            req.setRequestValue(value);
        }
        return req;
    }

    public PasswordModifyRequestDecorator decorate(ExtendedRequest modelRequest) {
        if (modelRequest instanceof PasswordModifyRequestDecorator) {
            return (PasswordModifyRequestDecorator)modelRequest;
        }
        return new PasswordModifyRequestDecorator(this.codec, (PasswordModifyRequest)modelRequest);
    }

    public PasswordModifyResponseDecorator decorate(ExtendedResponse decoratedResponse) {
        if (decoratedResponse instanceof PasswordModifyResponseDecorator) {
            return (PasswordModifyResponseDecorator)decoratedResponse;
        }
        if (decoratedResponse instanceof PasswordModifyResponse) {
            return new PasswordModifyResponseDecorator(this.codec, (PasswordModifyResponse)decoratedResponse);
        }
        ExtendedResponseDecorator response = (ExtendedResponseDecorator)decoratedResponse;
        Asn1Decoder decoder = new Asn1Decoder();
        byte[] value = response.getResponseValue();
        ByteBuffer buffer = ByteBuffer.wrap(value);
        PasswordModifyResponseContainer container = new PasswordModifyResponseContainer();
        PasswordModifyResponseDecorator pwdModifyResponse = null;
        try {
            decoder.decode(buffer, (Asn1Container)container);
            pwdModifyResponse = container.getPwdModifyResponse();
            pwdModifyResponse.getLdapResult().setResultCode(response.getLdapResult().getResultCode());
            pwdModifyResponse.getLdapResult().setDiagnosticMessage(response.getLdapResult().getDiagnosticMessage());
            pwdModifyResponse.getLdapResult().setMatchedDn(response.getLdapResult().getMatchedDn());
            pwdModifyResponse.getLdapResult().setReferral(response.getLdapResult().getReferral());
        }
        catch (DecoderException de) {
            StringWriter sw = new StringWriter();
            de.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            pwdModifyResponse = new PasswordModifyResponseImpl(decoratedResponse.getMessageId(), ResultCodeEnum.OPERATIONS_ERROR, stackTrace);
        }
        PasswordModifyResponseDecorator decorated = new PasswordModifyResponseDecorator(this.codec, pwdModifyResponse);
        Control ppolicyControl = response.getControl("1.3.6.1.4.1.42.2.27.8.5.1");
        if (ppolicyControl != null) {
            decorated.addControl(ppolicyControl);
        }
        return decorated;
    }
}

