/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.aci.ACIItemChecker;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class ACIItemSyntaxChecker
extends SyntaxChecker {
    private transient ACIItemChecker aciItemChecker;
    public static final ACIItemSyntaxChecker INSTANCE = new ACIItemSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.1", null);

    private ACIItemSyntaxChecker(String oid, SchemaManager schemaManager) {
        super(oid);
        this.aciItemChecker = new ACIItemChecker(schemaManager);
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        try {
            ACIItemChecker aCIItemChecker = this.aciItemChecker;
            synchronized (aCIItemChecker) {
                this.aciItemChecker.parse(strValue);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13701_SYNTAX_VALID, (Object[])new Object[]{value}));
            }
            return true;
        }
        catch (ParseException pe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.aciItemChecker = new ACIItemChecker(schemaManager);
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<ACIItemSyntaxChecker> {
        private SchemaManager schemaManager;

        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.1");
        }

        public Builder setSchemaManager(SchemaManager schemaManager) {
            this.schemaManager = schemaManager;
            return this;
        }

        public ACIItemSyntaxChecker build() {
            return new ACIItemSyntaxChecker(this.oid, this.schemaManager);
        }
    }
}

