/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.template;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class MemoryClearingBuffer {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private byte[] computedBytes;
    private char[] computedChars;
    private byte[] originalBytes;
    private char[] originalChars;
    private char[] precomputedChars;

    private MemoryClearingBuffer(byte[] originalBytes, char[] originalChars, boolean trim, boolean lowerCase) {
        this.originalBytes = originalBytes;
        this.originalChars = originalChars;
        if (trim || lowerCase) {
            int startIndex;
            if (this.originalChars == null) {
                throw new UnsupportedOperationException("trim and lowerCase only applicable to char[]");
            }
            char[] working = Arrays.copyOf(originalChars, originalChars.length);
            int endIndex = working.length;
            if (trim) {
                for (startIndex = 0; startIndex < working.length && Character.isWhitespace(working[startIndex]); ++startIndex) {
                }
                --endIndex;
                while (endIndex > startIndex && Character.isWhitespace(working[endIndex])) {
                    --endIndex;
                }
                ++endIndex;
            }
            if (lowerCase) {
                for (int i = startIndex; i < endIndex; ++i) {
                    working[i] = Character.toLowerCase(working[i]);
                }
            }
            this.precomputedChars = new char[endIndex - startIndex];
            System.arraycopy(working, startIndex, this.precomputedChars, 0, endIndex - startIndex);
        } else {
            this.precomputedChars = this.originalChars;
        }
    }

    public static MemoryClearingBuffer newInstance(byte[] bytes) {
        return new MemoryClearingBuffer(bytes, null, false, false);
    }

    public static MemoryClearingBuffer newInstance(char[] chars) {
        return new MemoryClearingBuffer(null, chars, false, false);
    }

    public static MemoryClearingBuffer newInstance(char[] chars, boolean trim, boolean lowerCase) {
        return new MemoryClearingBuffer(null, chars, trim, lowerCase);
    }

    public void clear() {
        if (this.computedBytes != null) {
            Arrays.fill(this.computedBytes, (byte)0);
        }
        if (this.computedChars != null) {
            Arrays.fill(this.computedChars, '0');
        }
        if (this.precomputedChars != null) {
            Arrays.fill(this.precomputedChars, '0');
        }
        this.computedBytes = null;
        this.computedChars = null;
        this.originalBytes = null;
        this.originalChars = null;
        this.precomputedChars = null;
    }

    byte[] getComputedBytes() {
        if (this.computedBytes == null) {
            ByteBuffer byteBuffer = UTF8.encode(CharBuffer.wrap(this.precomputedChars, 0, this.precomputedChars.length));
            this.computedBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(this.computedBytes);
            byteBuffer.flip();
            byte[] nullifier = new byte[byteBuffer.limit()];
            Arrays.fill(nullifier, (byte)0);
            byteBuffer.put(nullifier);
        }
        return this.computedBytes;
    }

    private char[] getComputedChars() {
        if (this.computedChars == null) {
            CharBuffer charBuffer = UTF8.decode(ByteBuffer.wrap(this.originalBytes, 0, this.originalBytes.length));
            this.computedChars = new char[charBuffer.remaining()];
            charBuffer.get(this.computedChars);
            charBuffer.flip();
            char[] nullifier = new char[charBuffer.limit()];
            Arrays.fill(nullifier, '\u0000');
            charBuffer.put(nullifier);
        }
        return this.computedChars;
    }

    public byte[] getBytes() {
        return this.originalBytes == null ? this.getComputedBytes() : this.originalBytes;
    }

    public char[] getChars() {
        return this.precomputedChars == null ? this.getComputedChars() : this.precomputedChars;
    }
}

