/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.ber.grammar;

import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.asn1.util.Asn1StringUtils;

public class GrammarTransition<C extends Asn1Container> {
    private Action<C> action;
    private Enum<?> previousState;
    private Enum<?> currentState;
    private int currentTag;
    private Grammar.FollowUp followUp;

    public GrammarTransition(Enum<?> previousState, Enum<?> currentState, int currentTag, Action<C> action, Grammar.FollowUp followUp) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.action = action;
        this.currentTag = currentTag;
        this.followUp = followUp;
    }

    public GrammarTransition(Enum<?> previousState, Enum<?> currentState, int currentTag, Grammar.FollowUp followUp) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.currentTag = currentTag;
        this.followUp = followUp;
    }

    public GrammarTransition(Enum<?> previousState, Enum<?> currentState, UniversalTag currentTag, Action<C> action, Grammar.FollowUp followUp) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.action = action;
        this.currentTag = currentTag.getValue();
        this.followUp = followUp;
    }

    public GrammarTransition(Enum<?> previousState, Enum<?> currentState, UniversalTag currentTag, Grammar.FollowUp followUp) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.currentTag = currentTag.getValue();
        this.followUp = followUp;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public Action<C> getAction() {
        return this.action;
    }

    public Enum<?> getCurrentState() {
        return this.currentState;
    }

    public Enum<?> getPreviousState() {
        return this.previousState;
    }

    public boolean hasFollowUp() {
        return this.followUp == Grammar.FollowUp.MANDATORY;
    }

    public void setFollowUp(Grammar.FollowUp followUp) {
        this.followUp = followUp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transition from state <").append(this.previousState).append("> ");
        sb.append("to state <").append(this.currentState).append(">, ");
        sb.append("tag <").append(Asn1StringUtils.dumpByte((byte)((byte)this.currentTag))).append(">, ");
        sb.append("action : ");
        if (this.action == null) {
            sb.append("no action");
        } else {
            sb.append(this.action);
        }
        if (Grammar.FollowUp.MANDATORY == this.followUp) {
            sb.append(", mandatory follow up");
        }
        return sb.toString();
    }
}

