/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.cancel;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.cancel.CancelResponse;
import org.apache.directory.api.ldap.model.message.AbstractExtendedResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class CancelResponseImpl
extends AbstractExtendedResponse
implements CancelResponse {
    public CancelResponseImpl(int messageId, ResultCodeEnum rcode) {
        super(messageId);
        switch (rcode) {
            case SUCCESS: 
            case CANCELED: 
            case CANNOT_CANCEL: 
            case NO_SUCH_OPERATION: 
            case TOO_LATE: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13503_RESULT_CODE_SHOULD_BE_IN, new Object[]{ResultCodeEnum.SUCCESS, ResultCodeEnum.OPERATIONS_ERROR, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS}));
            }
        }
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public CancelResponseImpl(int messageId) {
        super(messageId);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public CancelResponseImpl() {
        super("1.3.6.1.1.8");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    @Override
    public String getResponseName() {
        return "";
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + this.getClass().getName().hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof CancelResponseImpl;
    }
}

