/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.extractor.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.schema.extractor.SchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.extractor.UniqueResourceException;
import org.apache.directory.api.ldap.schema.extractor.impl.ResourceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaLdifExtractor
implements SchemaLdifExtractor {
    private static final String BASE_PATH = "";
    private static final String SCHEMA_SUBDIR = "schema";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaLdifExtractor.class);
    private static final Pattern EXTRACT_PATTERN = Pattern.compile(".*schema[/\\Q\\\\E]ou=schema.*\\.ldif");
    private boolean extracted;
    private File outputDirectory;

    public DefaultSchemaLdifExtractor(File outputDirectory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_16000_BASE_PATH, BASE_PATH, outputDirectory));
        }
        this.outputDirectory = outputDirectory;
        File schemaDirectory = new File(outputDirectory, SCHEMA_SUBDIR);
        if (!outputDirectory.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_16001_CREATING_DIR, outputDirectory));
            }
            if (!outputDirectory.mkdir()) {
                LOG.error(I18n.err(I18n.ERR_16042_OUTPUT_DIR_CREATION_FAIL, outputDirectory));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_16002_DIR_EXISTS, new Object[0]));
        }
        if (!schemaDirectory.exists()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg(I18n.MSG_16004_SCHEMA_DIR_ABSENT, schemaDirectory));
            }
            this.extracted = false;
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg(I18n.MSG_16005_SCHEMA_DIR_PRESENT, schemaDirectory));
            }
            this.extracted = true;
        }
    }

    @Override
    public boolean isExtracted() {
        return this.extracted;
    }

    @Override
    public void extractOrCopy(boolean overwrite) throws IOException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException(I18n.err(I18n.ERR_16006_DIRECTORY_CREATION_FAILED, this.outputDirectory.getAbsolutePath()));
        }
        File schemaDirectory = new File(this.outputDirectory, SCHEMA_SUBDIR);
        if (!schemaDirectory.exists()) {
            if (!schemaDirectory.mkdirs()) {
                throw new IOException(I18n.err(I18n.ERR_16006_DIRECTORY_CREATION_FAILED, schemaDirectory.getAbsolutePath()));
            }
        } else if (!overwrite) {
            throw new IOException(I18n.err(I18n.ERR_16000_CANNOT_OVEWRITE_SCHEMA, schemaDirectory.getAbsolutePath()));
        }
        Map<String, Boolean> list = ResourceMap.getResources(EXTRACT_PATTERN);
        for (Map.Entry<String, Boolean> entry : list.entrySet()) {
            if (entry.getValue().booleanValue()) {
                this.extractFromClassLoader(entry.getKey());
                continue;
            }
            File resource = new File(entry.getKey());
            this.copyFile(resource, this.getDestinationFile(resource));
        }
    }

    @Override
    public void extractOrCopy() throws IOException {
        this.extractOrCopy(false);
    }

    private void copyFile(File source, File destination) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_16003_COPYFILE, source, destination));
        }
        if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
            throw new IOException(I18n.err(I18n.ERR_16006_DIRECTORY_CREATION_FAILED, destination.getParentFile().getAbsolutePath()));
        }
        if (!source.getParentFile().exists()) {
            throw new FileNotFoundException(I18n.err(I18n.ERR_16001_CANNOT_COPY_NON_EXISTENT, source.getAbsolutePath()));
        }
        try (OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(Paths.get(destination.getPath(), new String[0]), new OpenOption[0]), Charset.defaultCharset());
             LdifReader ldifReader = new LdifReader(source);){
            boolean first = true;
            LdifEntry ldifEntry = null;
            while (ldifReader.hasNext()) {
                if (first) {
                    ldifEntry = ldifReader.next();
                    if (ldifEntry.get("entryUUID") == null) {
                        UUID entryUuid = UUID.randomUUID();
                        ldifEntry.addAttribute("entryUUID", entryUuid.toString());
                    }
                    first = false;
                    continue;
                }
                String msg = I18n.err(I18n.ERR_16002_MORE_THAN_ONE_ENTRY, source);
                LOG.error(msg);
                throw new InvalidObjectException(msg);
            }
            String ldifString = ldifEntry != null ? "version: 1\n" + ldifEntry.toString() : "version: 1\n";
            out.write(ldifString);
            ((Writer)out).flush();
        }
        catch (LdapException le) {
            String msg = I18n.err(I18n.ERR_16003_ERROR_PARSING_LDIF, source, le.getLocalizedMessage());
            LOG.error(msg);
            throw new InvalidObjectException(msg);
        }
    }

    private File assembleDestinationFile(Deque<String> fileComponentStack) {
        File destinationFile = this.outputDirectory.getAbsoluteFile();
        while (!fileComponentStack.isEmpty()) {
            destinationFile = new File(destinationFile, fileComponentStack.pop());
        }
        return destinationFile;
    }

    private File getDestinationFile(File resource) {
        ArrayDeque<String> fileComponentStack = new ArrayDeque<String>();
        fileComponentStack.push(resource.getName());
        for (File parent = resource.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (SCHEMA_SUBDIR.equals(parent.getName())) {
                fileComponentStack.push(SCHEMA_SUBDIR);
                return this.assembleDestinationFile(fileComponentStack);
            }
            fileComponentStack.push(parent.getName());
            if (!parent.equals(parent.getParentFile()) && parent.getParentFile() != null) continue;
            throw new IllegalStateException(I18n.err(I18n.ERR_16004_ROOT_WITHOUT_SCHEMA, new Object[0]));
        }
        throw new IllegalStateException(I18n.err(I18n.ERR_16005_PARENT_NULL, new Object[0]));
    }

    public static InputStream getUniqueResourceAsStream(String resourceName, String resourceDescription) throws IOException {
        URL result = DefaultSchemaLdifExtractor.getUniqueResource(BASE_PATH + resourceName, resourceDescription);
        return result.openStream();
    }

    public static URL getUniqueResource(String resourceName, String resourceDescription) throws IOException {
        Enumeration<URL> resources = DefaultSchemaLdifExtractor.class.getClassLoader().getResources(resourceName);
        if (!resources.hasMoreElements()) {
            throw new UniqueResourceException(resourceName, resourceDescription);
        }
        URL result = resources.nextElement();
        if (resources.hasMoreElements()) {
            throw new UniqueResourceException(resourceName, result, resources, resourceDescription);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFromClassLoader(String resource) throws IOException {
        byte[] buf = new byte[512];
        try (InputStream in = DefaultSchemaLdifExtractor.getUniqueResourceAsStream(resource, "LDIF file in schema repository");){
            File destination = new File(this.outputDirectory, resource);
            if (destination.exists()) {
                return;
            }
            if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
                throw new IOException(I18n.err(I18n.ERR_16006_DIRECTORY_CREATION_FAILED, destination.getParentFile().getAbsolutePath()));
            }
            try (OutputStream out = Files.newOutputStream(Paths.get(destination.getPath(), new String[0]), new OpenOption[0]);){
                while (in.available() > 0) {
                    int readCount = in.read(buf);
                    out.write(buf, 0, readCount);
                }
                out.flush();
            }
        }
    }
}

