// $ANTLR 2.7.7 (20060906): "TriggerSpecification.g" -> "AntlrTriggerSpecificationParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */


package org.apache.directory.api.ldap.trigger;

import java.util.ArrayList;
import java.util.List;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.NormalizerMappingResolver;
import org.apache.directory.api.ldap.trigger.StoredProcedureOption;
import org.apache.directory.api.ldap.trigger.StoredProcedureParameter;
import org.apache.directory.api.ldap.trigger.TriggerSpecification.SPSpec;
import org.apache.directory.api.ldap.model.message.SearchScope;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * The ANTLR generated TriggerSpecification parser.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class AntlrTriggerSpecificationParser extends antlr.LLkParser       implements AntlrTriggerSpecificationParserTokenTypes
 {

    private static final Logger log = LoggerFactory.getLogger( AntlrTriggerSpecificationParser.class );
    
    private NormalizerMappingResolver resolver;
    
    private ActionTime triggerActionTime;
    
    private LdapOperation triggerLdapOperation;
    
    private String triggerStoredProcedureName;
    
    private List<StoredProcedureParameter> triggerStoredProcedureParameters;
    
    private List<StoredProcedureOption> triggerStoredProcedureOptions;
    
    private List<SPSpec> spSpecs;   
    
    public void init()
    {
    }


    /**
     * Sets the NameComponentNormalizer for this parser's dnParser.
     *
     * @param resolver The resolver to use
     */
    public void setNormalizerMappingResolver( NormalizerMappingResolver resolver )
    {
        this.resolver = resolver;
    }

protected AntlrTriggerSpecificationParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrTriggerSpecificationParser(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected AntlrTriggerSpecificationParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrTriggerSpecificationParser(TokenStream lexer) {
  this(lexer,1);
}

public AntlrTriggerSpecificationParser(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final  TriggerSpecification  wrapperEntryPoint() throws RecognitionException, TokenStreamException {
		 TriggerSpecification triggerSpec ;
		
		
		log.debug( "entered wrapperEntryPoint()" );
		triggerSpec = null;
		spSpecs = new ArrayList<SPSpec>(); 
		
		
		{
		_loop3:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop3;
			}
			
		} while (true);
		}
		triggerSpec=triggerSpecification();
		match(Token.EOF_TYPE);
		return triggerSpec ;
	}
	
	public final  TriggerSpecification  triggerSpecification() throws RecognitionException, TokenStreamException {
		 TriggerSpecification triggerSpec ;
		
		
		log.debug( "entered triggerSpecification()" );
		triggerSpec = null;
		
		
		actionTime();
		{
		int _cnt6=0;
		_loop6:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt6>=1 ) { break _loop6; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt6++;
		} while (true);
		}
		ldapOperationAndStoredProcedureCalls();
		triggerSpec = new TriggerSpecification( triggerLdapOperation,
		triggerActionTime,
		spSpecs
		);
		
		return triggerSpec ;
	}
	
	public final void actionTime() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered actionTime()" );
		
		
		match(ID_AFTER);
		triggerActionTime = ActionTime.AFTER;
	}
	
	public final void ldapOperationAndStoredProcedureCalls() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ldapOperationAndStoredProcedureCall()" );
		
		
		switch ( LA(1)) {
		case ID_modify:
		{
			modifyOperationAndStoredProcedureCalls();
			triggerLdapOperation = LdapOperation.MODIFY;
			break;
		}
		case ID_add:
		{
			addOperationAndStoredProcedureCalls();
			triggerLdapOperation = LdapOperation.ADD;
			break;
		}
		case ID_delete:
		{
			deleteOperationAndStoredProcedureCalls();
			triggerLdapOperation = LdapOperation.DELETE;
			break;
		}
		case ID_modifyDN:
		{
			modifyDNOperationAndStoredProcedureCalls();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void modifyOperationAndStoredProcedureCalls() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered modifyOperationAndStoredProcedureCalls()" );
		
		
		match(ID_modify);
		{
		int _cnt11=0;
		_loop11:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt11>=1 ) { break _loop11; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt11++;
		} while (true);
		}
		{
		int _cnt20=0;
		_loop20:
		do {
			if ((LA(1)==ID_CALL)) {
				theCompositeRuleForCallAndSPNameAndSPOptionList();
				match(OPEN_PARAN);
				{
				_loop14:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop14;
					}
					
				} while (true);
				}
				{
				switch ( LA(1)) {
				case ID_object:
				case ID_modification:
				case ID_oldEntry:
				case ID_newEntry:
				case ID_operationPrincipal:
				case ID_ldapContext:
				{
					modifyStoredProcedureParameterList();
					break;
				}
				case CLOSE_PARAN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(CLOSE_PARAN);
				{
				_loop17:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop17;
					}
					
				} while (true);
				}
				match(SEMI);
				{
				_loop19:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop19;
					}
					
				} while (true);
				}
				
				spSpecs.add( new SPSpec(triggerStoredProcedureName, triggerStoredProcedureOptions, triggerStoredProcedureParameters ) );
				
			}
			else {
				if ( _cnt20>=1 ) { break _loop20; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt20++;
		} while (true);
		}
	}
	
	public final void addOperationAndStoredProcedureCalls() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered addOperationAndStoredProcedureCalls()" );
		
		
		match(ID_add);
		{
		int _cnt23=0;
		_loop23:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt23>=1 ) { break _loop23; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt23++;
		} while (true);
		}
		{
		int _cnt32=0;
		_loop32:
		do {
			if ((LA(1)==ID_CALL)) {
				theCompositeRuleForCallAndSPNameAndSPOptionList();
				match(OPEN_PARAN);
				{
				_loop26:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop26;
					}
					
				} while (true);
				}
				{
				switch ( LA(1)) {
				case ID_entry:
				case ID_attributes:
				case ID_operationPrincipal:
				case ID_ldapContext:
				{
					addStoredProcedureParameterList();
					break;
				}
				case CLOSE_PARAN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(CLOSE_PARAN);
				{
				_loop29:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop29;
					}
					
				} while (true);
				}
				match(SEMI);
				{
				_loop31:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop31;
					}
					
				} while (true);
				}
				
				spSpecs.add( new SPSpec(triggerStoredProcedureName, triggerStoredProcedureOptions, triggerStoredProcedureParameters ) );
				
			}
			else {
				if ( _cnt32>=1 ) { break _loop32; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt32++;
		} while (true);
		}
	}
	
	public final void deleteOperationAndStoredProcedureCalls() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered deleteOperationAndStoredProcedureCalls()" );
		
		
		match(ID_delete);
		{
		int _cnt35=0;
		_loop35:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt35>=1 ) { break _loop35; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt35++;
		} while (true);
		}
		{
		int _cnt44=0;
		_loop44:
		do {
			if ((LA(1)==ID_CALL)) {
				theCompositeRuleForCallAndSPNameAndSPOptionList();
				match(OPEN_PARAN);
				{
				_loop38:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop38;
					}
					
				} while (true);
				}
				{
				switch ( LA(1)) {
				case ID_name:
				case ID_deletedEntry:
				case ID_operationPrincipal:
				case ID_ldapContext:
				{
					deleteStoredProcedureParameterList();
					break;
				}
				case CLOSE_PARAN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(CLOSE_PARAN);
				{
				_loop41:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop41;
					}
					
				} while (true);
				}
				match(SEMI);
				{
				_loop43:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop43;
					}
					
				} while (true);
				}
				
				spSpecs.add( new SPSpec(triggerStoredProcedureName, triggerStoredProcedureOptions, triggerStoredProcedureParameters ) );
				
			}
			else {
				if ( _cnt44>=1 ) { break _loop44; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt44++;
		} while (true);
		}
	}
	
	public final void modifyDNOperationAndStoredProcedureCalls() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered modifyDNOperationAndStoredProcedureCalls()" );
		
		
		match(ID_modifyDN);
		match(DOT);
		{
		int _cnt57=0;
		_loop57:
		do {
			if (((LA(1) >= ID_modifyDNRename && LA(1) <= ID_modifyDNImport))) {
				{
				switch ( LA(1)) {
				case ID_modifyDNRename:
				{
					match(ID_modifyDNRename);
					triggerLdapOperation = LdapOperation.MODIFYDN_RENAME;
					break;
				}
				case ID_modifyDNExport:
				{
					match(ID_modifyDNExport);
					triggerLdapOperation = LdapOperation.MODIFYDN_EXPORT;
					break;
				}
				case ID_modifyDNImport:
				{
					match(ID_modifyDNImport);
					triggerLdapOperation = LdapOperation.MODIFYDN_IMPORT;
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				{
				int _cnt49=0;
				_loop49:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						if ( _cnt49>=1 ) { break _loop49; } else {throw new NoViableAltException(LT(1), getFilename());}
					}
					
					_cnt49++;
				} while (true);
				}
				theCompositeRuleForCallAndSPNameAndSPOptionList();
				match(OPEN_PARAN);
				{
				_loop51:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop51;
					}
					
				} while (true);
				}
				{
				switch ( LA(1)) {
				case ID_entry:
				case ID_newrdn:
				case ID_deleteoldrdn:
				case ID_newSuperior:
				case ID_oldRDN:
				case ID_oldSuperiorDN:
				case ID_newDN:
				case ID_operationPrincipal:
				case ID_ldapContext:
				{
					modifyDNStoredProcedureParameterList();
					break;
				}
				case CLOSE_PARAN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(CLOSE_PARAN);
				{
				_loop54:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop54;
					}
					
				} while (true);
				}
				match(SEMI);
				{
				_loop56:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop56;
					}
					
				} while (true);
				}
				
				spSpecs.add( new SPSpec(triggerStoredProcedureName, triggerStoredProcedureOptions, triggerStoredProcedureParameters ) );
				
			}
			else {
				if ( _cnt57>=1 ) { break _loop57; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt57++;
		} while (true);
		}
	}
	
	public final void theCompositeRuleForCallAndSPNameAndSPOptionList() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered theCompositeRuleForCallAndSPNameAndSPOptionList()" );
		
		
		match(ID_CALL);
		
		triggerStoredProcedureName = null;
		triggerStoredProcedureParameters = new ArrayList<StoredProcedureParameter>();
		triggerStoredProcedureOptions = new ArrayList<StoredProcedureOption>();
		
		{
		int _cnt60=0;
		_loop60:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt60>=1 ) { break _loop60; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt60++;
		} while (true);
		}
		triggerStoredProcedureName=fullyQualifiedStoredProcedureName();
		{
		_loop62:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop62;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			genericStoredProcedureOptionList();
			{
			_loop65:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop65;
				}
				
			} while (true);
			}
			break;
		}
		case OPEN_PARAN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
	}
	
	public final void modifyStoredProcedureParameterList() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered modifyStoredProcedureParameterList()" );
		
		
		modifyStoredProcedureParameter();
		{
		_loop68:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop68;
			}
			
		} while (true);
		}
		{
		_loop74:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop71:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop71;
					}
					
				} while (true);
				}
				modifyStoredProcedureParameter();
				{
				_loop73:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop73;
					}
					
				} while (true);
				}
			}
			else {
				break _loop74;
			}
			
		} while (true);
		}
	}
	
	public final void addStoredProcedureParameterList() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered addStoredProcedureParameterList()" );
		
		
		addStoredProcedureParameter();
		{
		_loop77:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop77;
			}
			
		} while (true);
		}
		{
		_loop83:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop80:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop80;
					}
					
				} while (true);
				}
				addStoredProcedureParameter();
				{
				_loop82:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop82;
					}
					
				} while (true);
				}
			}
			else {
				break _loop83;
			}
			
		} while (true);
		}
	}
	
	public final void deleteStoredProcedureParameterList() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered deleteStoredProcedureParameterList()" );
		
		
		deleteStoredProcedureParameter();
		{
		_loop86:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop86;
			}
			
		} while (true);
		}
		{
		_loop92:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop89:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop89;
					}
					
				} while (true);
				}
				deleteStoredProcedureParameter();
				{
				_loop91:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop91;
					}
					
				} while (true);
				}
			}
			else {
				break _loop92;
			}
			
		} while (true);
		}
	}
	
	public final void modifyDNStoredProcedureParameterList() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered modifyDNStoredProcedureParameterList()" );
		
		
		modifyDNStoredProcedureParameter();
		{
		_loop95:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop95;
			}
			
		} while (true);
		}
		{
		_loop101:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop98:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop98;
					}
					
				} while (true);
				}
				modifyDNStoredProcedureParameter();
				{
				_loop100:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop100;
					}
					
				} while (true);
				}
			}
			else {
				break _loop101;
			}
			
		} while (true);
		}
	}
	
	public final  String  fullyQualifiedStoredProcedureName() throws RecognitionException, TokenStreamException {
		 String spName ;
		
		Token  spNameToken = null;
		
		log.debug( "entered fullyQualifiedStoredProcedureName()" );
		spName = null;
		
		
		spNameToken = LT(1);
		match(UTF8String);
		spName = spNameToken.getText();
		return spName ;
	}
	
	public final void genericStoredProcedureOptionList() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered genericStoredProcedureOptionList()" );
		
		
		match(OPEN_CURLY);
		{
		_loop112:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop112;
			}
			
		} while (true);
		}
		{
		_loop122:
		do {
			if ((LA(1)==ID_languageScheme||LA(1)==ID_searchContext)) {
				genericStoredProcedureOption();
				{
				_loop115:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop115;
					}
					
				} while (true);
				}
				{
				_loop121:
				do {
					if ((LA(1)==SEP)) {
						match(SEP);
						{
						_loop118:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop118;
							}
							
						} while (true);
						}
						genericStoredProcedureOption();
						{
						_loop120:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop120;
							}
							
						} while (true);
						}
					}
					else {
						break _loop121;
					}
					
				} while (true);
				}
			}
			else {
				break _loop122;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void modifyStoredProcedureParameter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered modifyStoredProcedureParameter()" );
		
		
		switch ( LA(1)) {
		case ID_object:
		{
			match(ID_object);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Modify_OBJECT.instance() );
			break;
		}
		case ID_modification:
		{
			match(ID_modification);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Modify_MODIFICATION.instance() );
			break;
		}
		case ID_oldEntry:
		{
			match(ID_oldEntry);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Modify_OLD_ENTRY.instance() );
			break;
		}
		case ID_newEntry:
		{
			match(ID_newEntry);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Modify_NEW_ENTRY.instance() );
			break;
		}
		case ID_operationPrincipal:
		case ID_ldapContext:
		{
			genericStoredProcedureParameter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void addStoredProcedureParameter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered addStoredProcedureParameter()" );
		
		
		switch ( LA(1)) {
		case ID_entry:
		{
			match(ID_entry);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Add_ENTRY.instance() );
			break;
		}
		case ID_attributes:
		{
			match(ID_attributes);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Add_ATTRIBUTES.instance() );
			break;
		}
		case ID_operationPrincipal:
		case ID_ldapContext:
		{
			genericStoredProcedureParameter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void deleteStoredProcedureParameter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered deleteStoredProcedureParameter()" );
		
		
		switch ( LA(1)) {
		case ID_name:
		{
			match(ID_name);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Delete_NAME.instance() );
			break;
		}
		case ID_deletedEntry:
		{
			match(ID_deletedEntry);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Delete_DELETED_ENTRY.instance() );
			break;
		}
		case ID_operationPrincipal:
		case ID_ldapContext:
		{
			genericStoredProcedureParameter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void modifyDNStoredProcedureParameter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered modifyDNStoredProcedureParameter()" );
		
		
		switch ( LA(1)) {
		case ID_entry:
		{
			match(ID_entry);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.ModifyDN_ENTRY.instance() );
			break;
		}
		case ID_newrdn:
		{
			match(ID_newrdn);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.ModifyDN_NEW_RDN.instance() );
			break;
		}
		case ID_deleteoldrdn:
		{
			match(ID_deleteoldrdn);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.ModifyDN_DELETE_OLD_RDN.instance() );
			break;
		}
		case ID_newSuperior:
		{
			match(ID_newSuperior);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.ModifyDN_NEW_SUPERIOR.instance() );
			break;
		}
		case ID_oldRDN:
		{
			match(ID_oldRDN);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.ModifyDN_OLD_RDN.instance() );
			break;
		}
		case ID_oldSuperiorDN:
		{
			match(ID_oldSuperiorDN);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.ModifyDN_OLD_SUPERIOR_DN.instance() );
			break;
		}
		case ID_newDN:
		{
			match(ID_newDN);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.ModifyDN_NEW_DN.instance() );
			break;
		}
		case ID_operationPrincipal:
		case ID_ldapContext:
		{
			genericStoredProcedureParameter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void genericStoredProcedureParameter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered genericStoredProcedureParameter()" );
		
		
		switch ( LA(1)) {
		case ID_ldapContext:
		{
			ldapContextStoredProcedureParameter();
			break;
		}
		case ID_operationPrincipal:
		{
			match(ID_operationPrincipal);
			triggerStoredProcedureParameters.add( StoredProcedureParameter.Generic_OPERATION_PRINCIPAL.instance() );
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void ldapContextStoredProcedureParameter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ldapContextStoredProcedureParameter()" );
		Dn ldapContext = null;
		
		
		match(ID_ldapContext);
		{
		int _cnt109=0;
		_loop109:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt109>=1 ) { break _loop109; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt109++;
		} while (true);
		}
		ldapContext=distinguishedName();
		triggerStoredProcedureParameters.add( StoredProcedureParameter.Generic_LDAP_CONTEXT.instance( ldapContext ) );
	}
	
	public final  Dn  distinguishedName() throws RecognitionException, TokenStreamException {
		 Dn name ;
		
		Token  nameToken = null;
		
		log.debug( "entered distinguishedName()" );
		name = null;
		
		
		try {      // for error handling
			nameToken = LT(1);
			match(UTF8String);
			
			name = new Dn( nameToken.getText() );
			
		}
		catch (Exception e) {
			
			throw new RecognitionException( I18n.err( I18n.ERR_11003_NAME_PARSE_FAILED, nameToken.getText(), e.getMessage() ) );
			
		}
		return name ;
	}
	
	public final void genericStoredProcedureOption() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered genericStoredProcedureOption()" );
		StoredProcedureOption spOption = null;
		
		
		{
		switch ( LA(1)) {
		case ID_languageScheme:
		{
			spOption=storedProcedureLanguageSchemeOption();
			break;
		}
		case ID_searchContext:
		{
			spOption=storedProcedureSearchContextOption();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		triggerStoredProcedureOptions.add( spOption );
	}
	
	public final  StoredProcedureLanguageSchemeOption  storedProcedureLanguageSchemeOption() throws RecognitionException, TokenStreamException {
		 StoredProcedureLanguageSchemeOption spLanguageSchemeOption ;
		
		Token  languageToken = null;
		
		log.debug( "entered storedProcedureLanguageSchemeOption()" );
		spLanguageSchemeOption = null;
		
		
		match(ID_languageScheme);
		{
		int _cnt127=0;
		_loop127:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt127>=1 ) { break _loop127; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt127++;
		} while (true);
		}
		languageToken = LT(1);
		match(UTF8String);
		spLanguageSchemeOption = new StoredProcedureLanguageSchemeOption( languageToken.getText() );
		return spLanguageSchemeOption ;
	}
	
	public final  StoredProcedureSearchContextOption  storedProcedureSearchContextOption() throws RecognitionException, TokenStreamException {
		 StoredProcedureSearchContextOption spSearchContextOption ;
		
		
		log.debug( "entered storedProcedureSearchContextOption()" );
		spSearchContextOption = null;
		SearchScope searchScope = SearchScope.OBJECT; // default scope
		Dn spSearchContext = null;
		
		
		match(ID_searchContext);
		{
		int _cnt130=0;
		_loop130:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt130>=1 ) { break _loop130; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt130++;
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			match(OPEN_CURLY);
			{
			_loop133:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop133;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case ID_search_scope:
			{
				match(ID_search_scope);
				{
				int _cnt136=0;
				_loop136:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						if ( _cnt136>=1 ) { break _loop136; } else {throw new NoViableAltException(LT(1), getFilename());}
					}
					
					_cnt136++;
				} while (true);
				}
				searchScope=storedProcedureSearchScope();
				{
				_loop138:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop138;
					}
					
				} while (true);
				}
				break;
			}
			case CLOSE_CURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(CLOSE_CURLY);
			{
			int _cnt140=0;
			_loop140:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt140>=1 ) { break _loop140; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt140++;
			} while (true);
			}
			break;
		}
		case UTF8String:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		spSearchContext=storedProcedureSearchContext();
		spSearchContextOption = new StoredProcedureSearchContextOption( spSearchContext, searchScope );
		return spSearchContextOption ;
	}
	
	public final  SearchScope  storedProcedureSearchScope() throws RecognitionException, TokenStreamException {
		 SearchScope scope ;
		
		
		log.debug( "entered storedProcedureSearchScope()" );
		scope = null;
		
		
		switch ( LA(1)) {
		case ID_scope_base:
		{
			match(ID_scope_base);
			scope = SearchScope.OBJECT;
			break;
		}
		case ID_scope_one:
		{
			match(ID_scope_one);
			scope = SearchScope.ONELEVEL;
			break;
		}
		case ID_scope_subtree:
		{
			match(ID_scope_subtree);
			scope = SearchScope.SUBTREE;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return scope ;
	}
	
	public final  Dn  storedProcedureSearchContext() throws RecognitionException, TokenStreamException {
		 Dn spSearchContext ;
		
		
		log.debug( "entered storedProcedureSearchContext()" );
		spSearchContext = null;
		
		
		spSearchContext=distinguishedName();
		return spSearchContext ;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"SP",
		"\"after\"",
		"\"modify\"",
		"OPEN_PARAN",
		"CLOSE_PARAN",
		"SEMI",
		"\"add\"",
		"\"delete\"",
		"\"modifydn\"",
		"DOT",
		"\"rename\"",
		"\"export\"",
		"\"import\"",
		"\"call\"",
		"SEP",
		"\"$object\"",
		"\"$modification\"",
		"\"$oldentry\"",
		"\"$newentry\"",
		"\"$entry\"",
		"\"$attributes\"",
		"\"$name\"",
		"\"$deletedentry\"",
		"\"$newrdn\"",
		"\"$deleteoldrdn\"",
		"\"$newSuperior\"",
		"\"$oldRdn\"",
		"\"$oldSuperiorDn\"",
		"\"$newDn\"",
		"\"$operationprincipal\"",
		"\"$ldapcontext\"",
		"OPEN_CURLY",
		"CLOSE_CURLY",
		"\"languagescheme\"",
		"UTF8String",
		"\"searchcontext\"",
		"\"scope\"",
		"\"base\"",
		"\"one\"",
		"\"subtree\"",
		"SAFEUTF8CHAR",
		"COMMENT",
		"IDENTIFIER",
		"ALPHA"
	};
	
	
	}
