/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import java.text.ParseException;
import org.apache.directory.api.ldap.aci.ACIItemChecker;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACIItemSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ACIItemSyntaxChecker.class);
    private ACIItemChecker aciItemChecker;

    public ACIItemSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        try {
            ACIItemChecker aCIItemChecker = this.aciItemChecker;
            synchronized (aCIItemChecker) {
                this.aciItemChecker.parse(strValue);
            }
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        catch (ParseException pe) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.aciItemChecker = new ACIItemChecker(schemaManager);
    }
}

