/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;

public class Utf8CcsidManager
extends CcsidManager {
    private static final String UTF8 = "UTF-8";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final CharsetEncoder encoder = UTF8_CHARSET.newEncoder();

    public Utf8CcsidManager() {
        super((byte)32, (byte)46, new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -63, -62, -61, -60, -59, -58}, new byte[]{-57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -63, -62, -61, -60, -59, -58});
    }

    public byte[] convertFromJavaString(String string, Agent agent) throws SqlException {
        try {
            ByteBuffer byteBuffer = this.encoder.encode(CharBuffer.wrap(string));
            if (byteBuffer.limit() == byteBuffer.capacity()) {
                return byteBuffer.array();
            }
            byte[] byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
            return byArray;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.7"), characterCodingException);
        }
    }

    public String convertToJavaString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public void startEncoding() {
        this.encoder.reset();
    }

    public boolean encode(CharBuffer charBuffer, ByteBuffer byteBuffer, Agent agent) throws SqlException {
        CoderResult coderResult = this.encoder.encode(charBuffer, byteBuffer, true);
        if (coderResult == CoderResult.UNDERFLOW) {
            coderResult = this.encoder.flush(byteBuffer);
        }
        if (coderResult == CoderResult.UNDERFLOW) {
            return true;
        }
        if (coderResult == CoderResult.OVERFLOW) {
            return false;
        }
        throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.7"));
    }
}

