/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.authorization;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.security.api.authorization.AccessDecisionState;
import org.apache.deltaspike.security.api.authorization.AccessDecisionVoter;
import org.apache.deltaspike.security.api.authorization.AccessDecisionVoterContext;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.security.api.authorization.Secured;
import org.apache.deltaspike.security.api.authorization.Secures;
import org.apache.deltaspike.security.api.authorization.SecurityViolation;
import org.apache.deltaspike.security.impl.authorization.AccessDeniedExceptionBroadcaster;
import org.apache.deltaspike.security.impl.util.SecurityUtils;
import org.apache.deltaspike.security.spi.authorization.EditableAccessDecisionVoterContext;

@Dependent
public class SecuredAnnotationAuthorizer {
    @Inject
    private AccessDecisionVoterContext voterContext;
    @Inject
    private AccessDeniedExceptionBroadcaster exceptionBroadcaster;

    @Secures
    @Secured(value={})
    public boolean doSecuredCheck(InvocationContext invocationContext) throws Exception {
        ArrayList<Class<? extends AccessDecisionVoter>> voterClasses = new ArrayList<Class<? extends AccessDecisionVoter>>();
        List<Annotation> annotatedTypeMetadata = this.extractMetadata(invocationContext);
        for (Annotation annotation : annotatedTypeMetadata) {
            if (Secured.class.isAssignableFrom(annotation.annotationType())) {
                voterClasses.addAll(Arrays.asList(((Secured)annotation).value()));
                continue;
            }
            if (!(this.voterContext instanceof EditableAccessDecisionVoterContext)) continue;
            ((EditableAccessDecisionVoterContext)this.voterContext).addMetaData(annotation.annotationType().getName(), (Object)annotation);
        }
        this.invokeVoters(invocationContext, voterClasses);
        return true;
    }

    private List<Annotation> extractMetadata(InvocationContext invocationContext) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Method method = invocationContext.getMethod();
        result.addAll(SecurityUtils.getAllAnnotations(method.getAnnotations()));
        result.addAll(SecurityUtils.getAllAnnotations(method.getDeclaringClass().getAnnotations()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeVoters(InvocationContext invocationContext, List<Class<? extends AccessDecisionVoter>> accessDecisionVoters) {
        if (accessDecisionVoters.isEmpty()) {
            return;
        }
        AccessDecisionState voterState = AccessDecisionState.VOTE_IN_PROGRESS;
        try {
            if (this.voterContext instanceof EditableAccessDecisionVoterContext) {
                ((EditableAccessDecisionVoterContext)this.voterContext).setState(voterState);
                ((EditableAccessDecisionVoterContext)this.voterContext).setSource((Object)invocationContext);
            }
            for (Class<? extends AccessDecisionVoter> voterClass : accessDecisionVoters) {
                AccessDecisionVoter voter = (AccessDecisionVoter)BeanProvider.getContextualReference(voterClass, (boolean)false, (Annotation[])new Annotation[0]);
                Set violations = voter.checkPermission(this.voterContext);
                if (violations == null || violations.size() <= 0) continue;
                if (this.voterContext instanceof EditableAccessDecisionVoterContext) {
                    voterState = AccessDecisionState.VIOLATION_FOUND;
                    for (SecurityViolation securityViolation : violations) {
                        ((EditableAccessDecisionVoterContext)this.voterContext).addViolation(securityViolation);
                    }
                }
                this.exceptionBroadcaster.broadcastAccessDeniedException(new AccessDeniedException(violations));
            }
        }
        finally {
            if (this.voterContext instanceof EditableAccessDecisionVoterContext) {
                if (AccessDecisionState.VOTE_IN_PROGRESS.equals((Object)voterState)) {
                    voterState = AccessDecisionState.NO_VIOLATION_FOUND;
                }
                ((EditableAccessDecisionVoterContext)this.voterContext).setState(voterState);
            }
        }
    }
}

