/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding;

import java.lang.annotation.Annotation;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding.MethodInvocationParameter;
import org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding.MockObject;
import org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding.MockObject2;
import org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding.SecuredBean1;
import org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding.SecuredBean2;
import org.apache.deltaspike.test.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SecurityParameterBindingTest {
    @Deployment
    public static WebArchive deploy() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"security-parameter-binding-test.war")).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndSecurityArchive())).addPackage(SecurityParameterBindingTest.class.getPackage())).addAsWebInfResource(ArchiveUtils.getBeansXml(), "beans.xml");
    }

    @Test
    public void simpleInterceptorThrowsExceptionWhenImproperlyAnnotated() {
        try {
            SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
            testBean.getResult(new MockObject2(false));
            Assert.fail((String)"Expected exception, IllegalStateException was not thrown");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void simpleInterceptorDeniesTest() {
        try {
            SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
            testBean.getResult(new MockObject(false));
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception: " + e));
        }
    }

    @Test
    public void simpleInterceptorAllowsTest() {
        SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertTrue((boolean)testBean.getResult(new MockObject(true)));
    }

    @Test
    public void simpleInterceptorIgnoresUnsecuredMethods() {
        SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertTrue((boolean)testBean.getResult(new MockObject(true)));
    }

    @Test
    public void simpleInterceptorTestOnMethodsDenies() {
        try {
            SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
            testBean.getBlockedResult(new MockObject(false));
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception: " + e));
        }
    }

    @Test
    public void simpleInterceptorTestOnMethodsAllows() {
        SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertTrue((boolean)testBean.getBlockedResult(new MockObject(true)));
    }

    @Test
    public void afterInvocationAuthorizerCheckWithAllowedResult() {
        SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertTrue((boolean)testBean.getResult(true).isValue());
    }

    @Test
    public void afterInvocationAuthorizerCheckWithDeniedResult() {
        try {
            SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
            testBean.getResult(false);
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void afterInvocationAuthorizerWithoutReturnType() {
        MethodInvocationParameter parameter = new MethodInvocationParameter();
        try {
            SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
            testBean.securityCheckAfterMethodInvocation(parameter);
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException e) {
            Assert.assertTrue((boolean)parameter.isMethodInvoked());
        }
    }

    @Test
    public void afterInvocationAuthorizerWithVoidReturnType() {
        MethodInvocationParameter parameter = new MethodInvocationParameter();
        try {
            SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
            testBean.securityCheckAfterMethodInvocationWithVoidResult(parameter);
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException e) {
            Assert.assertTrue((boolean)parameter.isMethodInvoked());
        }
    }
}

