/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.authorization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.security.api.authorization.annotation.SecurityBindingType;

@Typed
abstract class SecurityUtils {
    private SecurityUtils() {
    }

    static boolean isMetaAnnotatedWithSecurityBindingType(Annotation annotation) {
        if (annotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) {
            return true;
        }
        List<Annotation> result = SecurityUtils.getAllAnnotations(annotation.annotationType().getAnnotations());
        for (Annotation foundAnnotation : result) {
            if (!SecurityBindingType.class.isAssignableFrom(foundAnnotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    static Annotation resolveSecurityBindingType(Annotation annotation) {
        List<Annotation> result = SecurityUtils.getAllAnnotations(annotation.annotationType().getAnnotations());
        for (Annotation foundAnnotation : result) {
            if (!foundAnnotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
            return foundAnnotation;
        }
        throw new IllegalStateException(annotation.annotationType().getName() + " is a " + Stereotype.class.getName() + " but it isn't annotated with " + SecurityBindingType.class.getName());
    }

    static List<Annotation> getAllAnnotations(Annotation[] annotations) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            String annotationName = annotation.annotationType().getName();
            if (annotationName.startsWith("java.") || annotationName.startsWith("javax.")) continue;
            result.add(annotation);
            result.addAll(SecurityUtils.getAllAnnotations(annotation.annotationType().getAnnotations()));
        }
        return result;
    }
}

