/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.authorization;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.util.metadata.builder.ParameterValueRedefiner;
import org.apache.deltaspike.security.api.authorization.annotation.SecurityParameterBinding;

public class SecurityParameterValueRedefiner
implements ParameterValueRedefiner {
    private CreationalContext<?> creationalContext;
    private InvocationContext invocation;

    public SecurityParameterValueRedefiner(CreationalContext<?> creationalContext, InvocationContext invocation) {
        this.invocation = invocation;
        this.creationalContext = creationalContext;
    }

    public Object redefineParameterValue(ParameterValueRedefiner.ParameterValue value) {
        InjectionPoint injectionPoint = value.getInjectionPoint();
        if (injectionPoint != null) {
            if (value.getInjectionPoint().getAnnotated().getBaseType().equals(InvocationContext.class)) {
                return this.invocation;
            }
            Annotated securingParameterAnnotatedType = injectionPoint.getAnnotated();
            Set securingParameterAnnotations = securingParameterAnnotatedType.getAnnotations();
            HashSet<Annotation> requiredBindingAnnotations = new HashSet<Annotation>();
            for (Annotation annotation : securingParameterAnnotations) {
                if (!annotation.annotationType().isAnnotationPresent(SecurityParameterBinding.class)) continue;
                requiredBindingAnnotations.add(annotation);
            }
            if (!requiredBindingAnnotations.isEmpty()) {
                Method method = this.invocation.getMethod();
                Annotation[][] businessMethodParameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < businessMethodParameterAnnotations.length; ++i) {
                    List<Annotation> businessParameterAnnotations = Arrays.asList(businessMethodParameterAnnotations[i]);
                    for (Annotation annotation : requiredBindingAnnotations) {
                        if (!businessParameterAnnotations.contains(annotation)) continue;
                        return this.invocation.getParameters()[i];
                    }
                }
                throw new IllegalStateException("Missing required security parameter binding " + requiredBindingAnnotations + " on method invocation [" + method.getDeclaringClass().getName() + "." + method.getName() + Arrays.asList(method.getParameterTypes()).toString().replaceFirst("\\[", "(").replaceFirst("\\]$", ")") + "]");
            }
        }
        return value.getDefaultValue(this.creationalContext);
    }
}

