/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ShrinkWrapArchiveUtil {
    private static final Logger LOG = Logger.getLogger(ShrinkWrapArchiveUtil.class.getName());

    public static JavaArchive[] getArchives(ClassLoader classLoader, String markerFile, String[] includeIfPackageExists, String[] excludeIfPackageExists) {
        if (classLoader == null) {
            classLoader = ShrinkWrapArchiveUtil.class.getClassLoader();
        }
        try {
            Enumeration<URL> foundFiles = classLoader.getResources(markerFile);
            ArrayList<JavaArchive> archives = new ArrayList<JavaArchive>();
            while (foundFiles.hasMoreElements()) {
                URL foundFile = foundFiles.nextElement();
                LOG.fine("Evaluating Java ClassPath URL " + foundFile.toExternalForm());
                JavaArchive archive = ShrinkWrapArchiveUtil.createArchive(foundFile, markerFile, includeIfPackageExists, excludeIfPackageExists);
                if (archive == null) continue;
                LOG.info("Adding Java ClassPath URL as JavaArchive " + foundFile.toExternalForm());
                archives.add(archive);
            }
            return archives.toArray(new JavaArchive[archives.size()]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static JavaArchive createArchive(URL foundFile, String markerFile, String[] includeIfPackageExists, String[] excludeIfPackageExists) throws IOException {
        String urlString = foundFile.toString();
        int idx = urlString.lastIndexOf(markerFile);
        String jarUrlPath = ShrinkWrapArchiveUtil.isJarUrl(urlString = urlString.substring(0, idx));
        if (jarUrlPath != null) {
            JavaArchive foundJar = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)new File(URI.create(jarUrlPath)));
            if (excludeIfPackageExists != null) {
                for (String excludePackage : excludeIfPackageExists) {
                    if (!foundJar.contains(excludePackage.replaceAll("\\.", "\\/"))) continue;
                    return null;
                }
            }
            if (includeIfPackageExists != null) {
                for (String includePackage : includeIfPackageExists) {
                    if (!foundJar.contains(includePackage.replaceAll("\\.", "\\/"))) continue;
                    return foundJar;
                }
            }
            return null;
        }
        File f = new File(new URL(ShrinkWrapArchiveUtil.ensureCorrectUrlFormat(urlString)).getFile());
        if (!f.exists() && urlString.contains("%20")) {
            urlString = urlString.replaceAll("%20", " ");
            f = new File(new URL(ShrinkWrapArchiveUtil.ensureCorrectUrlFormat(urlString)).getFile());
        }
        return ShrinkWrapArchiveUtil.addFileArchive(f, includeIfPackageExists, excludeIfPackageExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaArchive addJarArchive(InputStream inputStream, String[] includeIfPackageExists, String[] excludeIfPackageExists) throws IOException {
        JavaArchive ret = null;
        JavaArchive javaArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        if (includeIfPackageExists == null) {
            ret = javaArchive;
        }
        JarInputStream jar = new JarInputStream(inputStream);
        try {
            ZipEntry jarEntry = jar.getNextEntry();
            while (jarEntry != null) {
                String entryName = jarEntry.getName();
                if (jarEntry.isDirectory()) {
                    if (ShrinkWrapArchiveUtil.excludeIfPackageExists(entryName, excludeIfPackageExists)) {
                        JavaArchive javaArchive2 = null;
                        return javaArchive2;
                    }
                    if (ret == null && ShrinkWrapArchiveUtil.includeIfPackageExists(entryName, includeIfPackageExists)) {
                        ret = javaArchive;
                    }
                } else if (entryName.endsWith(".class")) {
                    String className = ShrinkWrapArchiveUtil.pathToClassName(entryName.substring(0, entryName.length() - ".class".length()));
                    javaArchive.addClass(className);
                } else {
                    javaArchive.addAsResource(entryName);
                }
                jarEntry = jar.getNextEntry();
            }
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException ignored) {}
        }
        return ret;
    }

    private static JavaArchive addFileArchive(File archiveBasePath, String[] includeIfPackageExists, String[] excludeIfPackageExists) throws IOException {
        if (!archiveBasePath.exists()) {
            return null;
        }
        JavaArchive ret = null;
        JavaArchive javaArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        if (includeIfPackageExists == null) {
            ret = javaArchive;
        }
        int basePathLength = archiveBasePath.getAbsolutePath().length() + 1;
        for (File archiveEntry : ShrinkWrapArchiveUtil.collectArchiveEntries(archiveBasePath)) {
            String entryName = archiveEntry.getAbsolutePath().substring(basePathLength);
            if (ShrinkWrapArchiveUtil.excludeIfPackageExists(entryName, excludeIfPackageExists)) continue;
            if (ret == null && ShrinkWrapArchiveUtil.includeIfPackageExists(entryName, includeIfPackageExists)) {
                ret = javaArchive;
            }
            if (entryName.endsWith(".class")) {
                String className = ShrinkWrapArchiveUtil.pathToClassName(entryName.substring(0, entryName.length() - ".class".length()));
                javaArchive.addClass(className);
                continue;
            }
            javaArchive.addAsResource(entryName.replace('\\', '/'));
        }
        return ret;
    }

    private static List<File> collectArchiveEntries(File archiveBasePath) {
        if (archiveBasePath.isDirectory()) {
            File[] files;
            ArrayList<File> archiveEntries = new ArrayList<File>();
            for (File file : files = archiveBasePath.listFiles()) {
                if (file.isDirectory()) {
                    archiveEntries.addAll(ShrinkWrapArchiveUtil.collectArchiveEntries(file));
                    continue;
                }
                archiveEntries.add(file);
            }
            return archiveEntries;
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean excludeIfPackageExists(String jarEntryName, String[] excludeOnPackages) {
        if (excludeOnPackages != null) {
            String packageName = ShrinkWrapArchiveUtil.pathToClassName(jarEntryName);
            for (String excludeOnPackage : excludeOnPackages) {
                if (!packageName.startsWith(excludeOnPackage)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean includeIfPackageExists(String jarEntryName, String[] includeOnPackages) {
        if (includeOnPackages == null) {
            return true;
        }
        String packageName = ShrinkWrapArchiveUtil.pathToClassName(jarEntryName);
        for (String includeOnPackage : includeOnPackages) {
            if (!packageName.startsWith(includeOnPackage)) continue;
            return true;
        }
        return false;
    }

    private static String isJarUrl(String urlPath) {
        int jarColon = urlPath.indexOf(58);
        if (urlPath.endsWith("!/") && jarColon > 0) {
            urlPath = urlPath.substring(jarColon + 1, urlPath.length() - 2);
            return urlPath;
        }
        return null;
    }

    private static String ensureCorrectUrlFormat(String url) {
        if (!url.startsWith("file:/")) {
            url = "file:/" + url;
        }
        return url;
    }

    private static String pathToClassName(String pathName) {
        return pathName.replace('/', '.').replace('\\', '.');
    }
}

