/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.security.impl.authentication;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.deltaspike.security.api.Identity;
import org.apache.deltaspike.test.security.impl.authentication.Inquiry;
import org.apache.deltaspike.test.security.impl.authentication.InquiryEntry;
import org.apache.deltaspike.test.security.impl.authentication.InquiryStorage;

@ApplicationScoped
public class TestInquiryStorage
implements InquiryStorage {
    private Map<String, InquiryEntry> userInquiries = new ConcurrentHashMap<String, InquiryEntry>();
    private Map<String, Inquiry> anonymInquiries = new ConcurrentHashMap<String, Inquiry>();
    @Inject
    private Identity identity;

    @Override
    public boolean addInquiry(Inquiry inquiry) {
        if (this.identity.isLoggedIn()) {
            this.userInquiries.put(inquiry.getInquiryId(), new InquiryEntry(this.identity.getUser().getId(), inquiry));
        } else {
            this.anonymInquiries.put(inquiry.getInquiryId(), inquiry);
        }
        return true;
    }

    Collection<InquiryEntry> getUserInquiries() {
        return this.userInquiries.values();
    }

    Collection<Inquiry> getAnonymInquiries() {
        return this.anonymInquiries.values();
    }
}

