/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.security.impl.authentication;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.apache.deltaspike.security.api.User;
import org.apache.deltaspike.security.api.credential.LoginCredential;
import org.apache.deltaspike.security.spi.authentication.Authenticator;
import org.apache.deltaspike.security.spi.authentication.BaseAuthenticator;
import org.apache.deltaspike.test.security.impl.authentication.InMemoryUserStorage;

@RequestScoped
public class TestAuthenticator
extends BaseAuthenticator {
    @Inject
    private LoginCredential loginCredential;
    private User user;

    public void authenticate() {
        String password = InMemoryUserStorage.getPassword(this.loginCredential.getUserId());
        if (password != null && password.equals(this.loginCredential.getCredential().getValue())) {
            this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
            this.user = new User(this.loginCredential.getUserId());
            return;
        }
        this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
    }

    public User getUser() {
        return this.user;
    }

    void register(String userName, String password) {
        InMemoryUserStorage.setPassword(userName, password);
    }
}

