/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.property;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;

public class Reflections {
    private Reflections() {
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static boolean methodExists(Class<?> clazz, String name) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                if (!m.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method a : c.getDeclaredMethods()) {
                methods.add(a);
            }
        }
        return methods;
    }

    public static Method findDeclaredMethod(Class<?> clazz, String name, Class<?> ... args) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredMethod(name, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    private static String buildInvokeMethodErrorMessage(Method method, Object obj, Object ... args) {
        StringBuilder message = new StringBuilder(String.format("Exception invoking method [%s] on object [%s], using arguments [", method.getName(), obj));
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                message.append((i > 0 ? "," : "") + args[i]);
            }
        }
        message.append("]");
        return message.toString();
    }

    public static <A extends AccessibleObject> A setAccessible(final A member) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                member.setAccessible(true);
                return null;
            }
        });
        return member;
    }

    public static Object invokeMethod(Method method, Object instance, Object ... args) {
        return Reflections.invokeMethod(false, method, Object.class, instance, args);
    }

    public static Object invokeMethod(boolean setAccessible, Method method, Object instance, Object ... args) {
        return Reflections.invokeMethod(setAccessible, method, Object.class, instance, args);
    }

    public static <T> T invokeMethod(Method method, Class<T> expectedReturnType, Object instance, Object ... args) {
        return Reflections.invokeMethod(false, method, expectedReturnType, instance, args);
    }

    public static <T> T invokeMethod(boolean setAccessible, Method method, Class<T> expectedReturnType, Object instance, Object ... args) {
        if (setAccessible && !method.isAccessible()) {
            Reflections.setAccessible(method);
        }
        try {
            return expectedReturnType.cast(method.invoke(instance, args));
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex.getCause());
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        Reflections.setFieldValue(false, field, instance, value);
    }

    public static void setFieldValue(boolean setAccessible, Field field, Object instance, Object value) {
        if (setAccessible && !field.isAccessible()) {
            Reflections.setAccessible(field);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(Reflections.buildSetFieldValueErrorMessage(field, instance, value), e);
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildSetFieldValueErrorMessage(field, instance, value));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildSetFieldValueErrorMessage(field, instance, value));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    private static String buildSetFieldValueErrorMessage(Field field, Object obj, Object value) {
        return String.format("Exception setting [%s] field on object [%s] to value [%s]", field.getName(), obj, value);
    }

    private static String buildGetFieldValueErrorMessage(Field field, Object obj) {
        return String.format("Exception reading [%s] field from object [%s].", field.getName(), obj);
    }

    public static Object getFieldValue(Field field, Object instance) {
        return Reflections.getFieldValue(field, instance, Object.class);
    }

    public static <T> T getFieldValue(Field field, Object instance, Class<T> expectedType) {
        try {
            return Reflections.cast(field.get(instance));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(Reflections.buildGetFieldValueErrorMessage(field, instance), e);
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildGetFieldValueErrorMessage(field, instance));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildGetFieldValueErrorMessage(field, instance));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }
}

