/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.owb;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.cdise.owb.MockHttpSession;
import org.apache.deltaspike.cdise.owb.MockServletContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.type.ContextTypes;

@Dependent
public class OpenWebBeansContextControl
implements ContextControl {
    private static final Logger LOG = Logger.getLogger(OpenWebBeansContextControl.class.getName());
    private Boolean servletApiAvailable = null;
    private Object session = null;
    private Object servletContext = null;

    protected boolean isServletApiAvailable() {
        if (this.servletApiAvailable == null) {
            try {
                Class<?> servletClass = Class.forName("javax.servlet.http.HttpSession");
                this.servletApiAvailable = servletClass != null;
                LOG.fine("Servlet API available: " + this.servletApiAvailable);
            }
            catch (ClassNotFoundException e) {
                this.servletApiAvailable = Boolean.FALSE;
            }
        }
        return this.servletApiAvailable;
    }

    protected Object getMockSession() {
        if (this.isServletApiAvailable() && this.session == null) {
            this.session = new MockHttpSession();
        }
        return this.session;
    }

    protected Object getMockServletContext() {
        if (this.isServletApiAvailable() && this.servletContext == null) {
            this.servletContext = new MockServletContext();
        }
        return this.servletContext;
    }

    public void startContexts() {
        ContextFactory contextFactory = this.getContextFactory();
        contextFactory.initSingletonContext(this.getMockServletContext());
        contextFactory.initApplicationContext(this.getMockServletContext());
        contextFactory.initSessionContext(this.getMockSession());
        contextFactory.initRequestContext(null);
        contextFactory.initConversationContext(null);
    }

    public void stopContexts() {
        this.stopSessionScope();
        this.stopConversationScope();
        this.stopRequestScope();
        this.stopApplicationScope();
        this.stopSingletonScope();
    }

    public void startContext(Class<? extends Annotation> scopeClass) {
        if (scopeClass.isAssignableFrom(ApplicationScoped.class)) {
            this.startApplicationScope();
        } else if (scopeClass.isAssignableFrom(SessionScoped.class)) {
            this.startSessionScope();
        } else if (scopeClass.isAssignableFrom(RequestScoped.class)) {
            this.startRequestScope();
        } else if (scopeClass.isAssignableFrom(ConversationScoped.class)) {
            this.startConversationScope();
        }
    }

    public void stopContext(Class<? extends Annotation> scopeClass) {
        if (scopeClass.isAssignableFrom(ApplicationScoped.class)) {
            this.stopApplicationScope();
        } else if (scopeClass.isAssignableFrom(SessionScoped.class)) {
            this.stopSessionScope();
        } else if (scopeClass.isAssignableFrom(RequestScoped.class)) {
            this.stopRequestScope();
        } else if (scopeClass.isAssignableFrom(ConversationScoped.class)) {
            this.stopConversationScope();
        }
    }

    private void startApplicationScope() {
        ContextFactory contextFactory = this.getContextFactory();
        contextFactory.initApplicationContext(this.getMockServletContext());
    }

    private void startSessionScope() {
        ContextFactory contextFactory = this.getContextFactory();
        contextFactory.initSessionContext(this.getMockSession());
    }

    private void startRequestScope() {
        ContextFactory contextFactory = this.getContextFactory();
        contextFactory.initRequestContext(null);
    }

    private void startConversationScope() {
        ContextFactory contextFactory = this.getContextFactory();
        contextFactory.initConversationContext(null);
    }

    private void stopSingletonScope() {
        ContextFactory contextFactory = this.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.SINGLETON);
        if (context != null) {
            contextFactory.destroySingletonContext(this.getMockServletContext());
        }
    }

    private void stopApplicationScope() {
        ContextFactory contextFactory = this.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.APPLICATION);
        if (context != null) {
            contextFactory.destroyApplicationContext(this.getMockServletContext());
        }
    }

    private void stopSessionScope() {
        ContextFactory contextFactory = this.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.SESSION);
        if (context != null) {
            contextFactory.destroySessionContext(this.getMockSession());
        }
    }

    private void stopRequestScope() {
        ContextFactory contextFactory = this.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.REQUEST);
        if (context != null) {
            contextFactory.destroyRequestContext(null);
        }
    }

    private void stopConversationScope() {
        ContextFactory contextFactory = this.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.CONVERSATION);
        if (context != null) {
            contextFactory.destroyConversationContext();
        }
    }

    private ContextFactory getContextFactory() {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        return webBeansContext.getContextFactory();
    }
}

