/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.util.List;
import org.apache.datasketches.req.FloatBuffer;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqSketch;

public class ReqIterator {
    private List<ReqCompactor> compactors;
    private int cIndex;
    private int bIndex;
    private int retainedItems;
    private int count;
    private FloatBuffer currentBuf;

    ReqIterator(ReqSketch sketch) {
        this.compactors = sketch.getCompactors();
        this.retainedItems = sketch.getRetainedItems();
        this.currentBuf = this.compactors.get(0).getBuffer();
        this.cIndex = 0;
        this.bIndex = -1;
        this.count = 0;
    }

    public boolean next() {
        if (this.retainedItems == 0 || this.cIndex == this.compactors.size() - 1 && this.bIndex == this.currentBuf.getCount() - 1) {
            return false;
        }
        if (this.bIndex == this.currentBuf.getCount() - 1) {
            ++this.cIndex;
            this.currentBuf = this.compactors.get(this.cIndex).getBuffer();
            this.bIndex = 0;
        } else {
            ++this.bIndex;
        }
        ++this.count;
        return true;
    }

    public float getValue() {
        return this.currentBuf.getItem(this.bIndex);
    }

    public long getWeight() {
        return 1 << this.cIndex;
    }

    public int getCount() {
        return this.count;
    }
}

