/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.BoundsOnBinomialProportions;

final class SamplingUtil {
    private static final double DEFAULT_KAPPA = 2.0;

    private SamplingUtil() {
    }

    static int getAdjustedSize(int maxSize, int resizeTarget) {
        if ((long)(maxSize - (resizeTarget << 1)) < 0L) {
            return maxSize;
        }
        return resizeTarget;
    }

    static double nextDoubleExcludeZero() {
        double r = SamplingUtil.rand().nextDouble();
        while (r == 0.0) {
            r = SamplingUtil.rand().nextDouble();
        }
        return r;
    }

    static int startingSubMultiple(int lgTarget, int lgRf, int lgMin) {
        return lgTarget <= lgMin ? lgMin : (lgRf == 0 ? lgTarget : (lgTarget - lgMin) % lgRf + lgMin);
    }

    static double pseudoHypergeometricUBonP(long n, int k, double samplingRate) {
        double adjustedKappa = 2.0 * Math.sqrt(1.0 - samplingRate);
        return BoundsOnBinomialProportions.approximateUpperBoundOnP(n, k, adjustedKappa);
    }

    static double pseudoHypergeometricLBonP(long n, int k, double samplingRate) {
        double adjustedKappa = 2.0 * Math.sqrt(1.0 - samplingRate);
        return BoundsOnBinomialProportions.approximateLowerBoundOnP(n, k, adjustedKappa);
    }

    public static Random rand() {
        return ThreadLocalRandom.current();
    }
}

