/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Random;
import org.apache.datasketches.Family;
import org.apache.datasketches.QuantilesHelper;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketchR;
import org.apache.datasketches.quantiles.DoublesAuxiliary;
import org.apache.datasketches.quantiles.DoublesByteArrayImpl;
import org.apache.datasketches.quantiles.DoublesMergeImpl;
import org.apache.datasketches.quantiles.DoublesPmfCdfImpl;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesSketchBuilder;
import org.apache.datasketches.quantiles.DoublesSketchIterator;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;

public abstract class DoublesSketch {
    static final int DOUBLES_SER_VER = 3;
    static final int MAX_PRELONGS = Family.QUANTILES.getMaxPreLongs();
    static final int MIN_K = 2;
    static final int MAX_K = 32768;
    static Random rand = new Random();
    final int k_;

    DoublesSketch(int k) {
        org.apache.datasketches.quantiles.Util.checkK(k);
        this.k_ = k;
    }

    static synchronized void setRandom(long seed) {
        rand = new Random(seed);
    }

    public static final DoublesSketchBuilder builder() {
        return new DoublesSketchBuilder();
    }

    public static DoublesSketch heapify(Memory srcMem) {
        if (org.apache.datasketches.quantiles.Util.checkIsCompactMemory(srcMem)) {
            return CompactDoublesSketch.heapify(srcMem);
        }
        return UpdateDoublesSketch.heapify(srcMem);
    }

    public static DoublesSketch wrap(Memory srcMem) {
        if (org.apache.datasketches.quantiles.Util.checkIsCompactMemory(srcMem)) {
            return DirectCompactDoublesSketch.wrapInstance(srcMem);
        }
        return DirectUpdateDoublesSketchR.wrapInstance(srcMem);
    }

    public double getQuantile(double fraction) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        if (fraction < 0.0 || fraction > 1.0) {
            throw new SketchesArgumentException("Fraction cannot be less than zero or greater than 1.0");
        }
        if (fraction == 0.0) {
            return this.getMinValue();
        }
        if (fraction == 1.0) {
            return this.getMaxValue();
        }
        DoublesAuxiliary aux = new DoublesAuxiliary(this);
        return aux.getQuantile(fraction);
    }

    public double getQuantileUpperBound(double fraction) {
        return this.getQuantile(Math.min(1.0, fraction + org.apache.datasketches.quantiles.Util.getNormalizedRankError(this.k_, false)));
    }

    public double getQuantileLowerBound(double fraction) {
        return this.getQuantile(Math.max(0.0, fraction - org.apache.datasketches.quantiles.Util.getNormalizedRankError(this.k_, false)));
    }

    public double[] getQuantiles(double[] fRanks) {
        if (this.isEmpty()) {
            return null;
        }
        DoublesAuxiliary aux = null;
        double[] quantiles = new double[fRanks.length];
        for (int i = 0; i < fRanks.length; ++i) {
            double fRank = fRanks[i];
            if (fRank == 0.0) {
                quantiles[i] = this.getMinValue();
                continue;
            }
            if (fRank == 1.0) {
                quantiles[i] = this.getMaxValue();
                continue;
            }
            if (aux == null) {
                aux = new DoublesAuxiliary(this);
            }
            quantiles[i] = aux.getQuantile(fRank);
        }
        return quantiles;
    }

    public double[] getQuantiles(int evenlySpaced) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getQuantiles(QuantilesHelper.getEvenlySpacedRanks(evenlySpaced));
    }

    public double getRank(double value) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        DoublesSketchAccessor samples = DoublesSketchAccessor.wrap(this);
        long total = 0L;
        int weight = 1;
        samples.setLevel(-1);
        for (int i = 0; i < samples.numItems(); ++i) {
            if (!(samples.get(i) < value)) continue;
            total += (long)weight;
        }
        int lvl = 0;
        for (long bitPattern = this.getBitPattern(); bitPattern != 0L; bitPattern >>>= 1) {
            weight *= 2;
            if ((bitPattern & 1L) > 0L) {
                samples.setLevel(lvl);
                for (int i = 0; i < samples.numItems() && samples.get(i) < value; ++i) {
                    total += (long)weight;
                }
            }
            ++lvl;
        }
        return (double)total / (double)this.getN();
    }

    public double[] getPMF(double[] splitPoints) {
        if (this.isEmpty()) {
            return null;
        }
        return DoublesPmfCdfImpl.getPMFOrCDF(this, splitPoints, false);
    }

    public double[] getCDF(double[] splitPoints) {
        if (this.isEmpty()) {
            return null;
        }
        return DoublesPmfCdfImpl.getPMFOrCDF(this, splitPoints, true);
    }

    public int getK() {
        return this.k_;
    }

    public abstract double getMinValue();

    public abstract double getMaxValue();

    public abstract long getN();

    @Deprecated
    public double getNormalizedRankError() {
        return org.apache.datasketches.quantiles.Util.getNormalizedRankError(this.getK(), true);
    }

    public double getNormalizedRankError(boolean pmf) {
        return org.apache.datasketches.quantiles.Util.getNormalizedRankError(this.k_, pmf);
    }

    @Deprecated
    public static double getNormalizedRankError(int k) {
        return org.apache.datasketches.quantiles.Util.getNormalizedRankError(k, true);
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return org.apache.datasketches.quantiles.Util.getNormalizedRankError(k, pmf);
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        return org.apache.datasketches.quantiles.Util.getKFromEpsilon(epsilon, pmf);
    }

    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    public abstract boolean isDirect();

    public boolean isEstimationMode() {
        return this.getN() >= 2L * (long)this.k_;
    }

    public boolean isSameResource(Memory that) {
        return false;
    }

    public byte[] toByteArray() {
        if (this.isCompact()) {
            return this.toByteArray(true);
        }
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean compact) {
        return DoublesByteArrayImpl.toByteArray(this, compact, compact);
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        return DoublesUtil.toString(sketchSummary, dataDetail, this);
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.toString(byteArr, true);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.toString(mem, true);
    }

    public DoublesSketch downSample(DoublesSketch srcSketch, int smallerK, WritableMemory dstMem) {
        return this.downSampleInternal(srcSketch, smallerK, dstMem);
    }

    public int getRetainedItems() {
        return org.apache.datasketches.quantiles.Util.computeRetainedItems(this.getK(), this.getN());
    }

    public int getCompactStorageBytes() {
        return DoublesSketch.getCompactStorageBytes(this.getK(), this.getN());
    }

    public static int getCompactStorageBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        int metaPreLongs = MAX_PRELONGS + 2;
        return metaPreLongs + org.apache.datasketches.quantiles.Util.computeRetainedItems(k, n) << 3;
    }

    public int getStorageBytes() {
        if (this.isCompact()) {
            return this.getCompactStorageBytes();
        }
        return this.getUpdatableStorageBytes();
    }

    public int getUpdatableStorageBytes() {
        return DoublesSketch.getUpdatableStorageBytes(this.getK(), this.getN());
    }

    public static int getUpdatableStorageBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        int metaPre = MAX_PRELONGS + 2;
        int totLevels = org.apache.datasketches.quantiles.Util.computeNumLevelsNeeded(k, n);
        if (n <= (long)k) {
            int ceil = Math.max(Util.ceilingPowerOf2((int)n), 4);
            return metaPre + ceil << 3;
        }
        return metaPre + (2 + totLevels) * k << 3;
    }

    public void putMemory(WritableMemory dstMem) {
        this.putMemory(dstMem, true);
    }

    public void putMemory(WritableMemory dstMem, boolean compact) {
        if (this.isDirect() && this.isCompact() == compact) {
            WritableMemory srcMem = this.getMemory();
            srcMem.copyTo(0L, dstMem, 0L, (long)this.getStorageBytes());
        } else {
            byte[] byteArr = this.toByteArray(compact);
            int arrLen = byteArr.length;
            long memCap = dstMem.getCapacity();
            if (memCap < (long)arrLen) {
                throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + arrLen);
            }
            dstMem.putByteArray(0L, byteArr, 0, arrLen);
        }
    }

    public DoublesSketchIterator iterator() {
        return new DoublesSketchIterator(this, this.getBitPattern());
    }

    UpdateDoublesSketch downSampleInternal(DoublesSketch srcSketch, int smallerK, WritableMemory dstMem) {
        UpdateDoublesSketch newSketch;
        UpdateDoublesSketch updateDoublesSketch = newSketch = dstMem == null ? HeapUpdateDoublesSketch.newInstance(smallerK) : DirectUpdateDoublesSketch.newInstance(smallerK, dstMem);
        if (srcSketch.isEmpty()) {
            return newSketch;
        }
        DoublesMergeImpl.downSamplingMergeInto(srcSketch, newSketch);
        return newSketch;
    }

    abstract boolean isCompact();

    abstract int getBaseBufferCount();

    abstract long getBitPattern();

    abstract int getCombinedBufferItemCapacity();

    abstract double[] getCombinedBuffer();

    abstract WritableMemory getMemory();
}

