/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllPairIterator;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;

class Hll8Array
extends HllArray {
    Hll8Array(int lgConfigK) {
        super(lgConfigK, TgtHllType.HLL_8);
        this.hllByteArr = new byte[Hll8Array.hll8ArrBytes(lgConfigK)];
    }

    Hll8Array(Hll8Array that) {
        super(that);
    }

    static final Hll8Array heapify(Memory mem) {
        int lgConfigK = PreambleUtil.extractLgK(mem);
        Hll8Array hll8Array = new Hll8Array(lgConfigK);
        HllArray.extractCommonHll(mem, hll8Array);
        return hll8Array;
    }

    @Override
    Hll8Array copy() {
        return new Hll8Array(this);
    }

    @Override
    PairIterator iterator() {
        return new HeapHll8Iterator(1 << this.lgConfigK);
    }

    @Override
    final int getSlot(int slotNo) {
        return this.hllByteArr[slotNo] & 0x3F;
    }

    @Override
    final void putSlot(int slotNo, int value) {
        this.hllByteArr[slotNo] = (byte)(value & 0x3F);
    }

    final class HeapHll8Iterator
    extends HllPairIterator {
        HeapHll8Iterator(int lengthPairs) {
            super(lengthPairs);
        }

        @Override
        int value() {
            return Hll8Array.this.hllByteArr[this.index] & 0x3F;
        }
    }
}

