/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.unparsers.PrimUnparser;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import org.apache.daffodil.runtime1.processors.unparsers.Unparser;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001-3Qa\u0002\u0005\u0002\u0002MA\u0001B\t\u0001\u0003\u0006\u0004%\te\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005I!)\u0011\u0006\u0001C\u0001U!Aa\u0006\u0001EC\u0002\u0013\u0005s\u0006C\u0003<\u0001\u0019EA\bC\u0003F\u0001\u0011\u0005cIA\u000bIKb\u0014\u0015N\\1ssVs\u0007/\u0019:tKJ\u0014\u0015m]3\u000b\u0005%Q\u0011\u0001\u0003:v]RLW.Z\u0019\u000b\u0005-a\u0011!C;oa\u0006\u00148/\u001a:t\u0015\tia\"\u0001\u0005eC\u001a4w\u000eZ5m\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tY\u0002%D\u0001\u001d\u0015\tYQD\u0003\u0002\u001f?\u0005Q\u0001O]8dKN\u001cxN]:\u000b\u0005%a\u0011BA\u0011\u001d\u00051\u0001&/[7V]B\f'o]3s\u0003\u001d\u0019wN\u001c;fqR,\u0012\u0001\n\t\u0003K\u0019j\u0011!H\u0005\u0003Ou\u0011!#\u00127f[\u0016tGOU;oi&lW\rR1uC\u0006A1m\u001c8uKb$\b%\u0001\u0004=S:LGO\u0010\u000b\u0003W5\u0002\"\u0001\f\u0001\u000e\u0003!AQAI\u0002A\u0002\u0011\n1C];oi&lW\rR3qK:$WM\\2jKN,\u0012\u0001\r\t\u0004cYBT\"\u0001\u001a\u000b\u0005M\"\u0014!C5n[V$\u0018M\u00197f\u0015\t)d#\u0001\u0006d_2dWm\u0019;j_:L!a\u000e\u001a\u0003\rY+7\r^8s!\t)\u0012(\u0003\u0002;-\t9aj\u001c;iS:<\u0017aD4fi2+gn\u001a;i\u0013:\u0014\u0015\u000e^:\u0015\u0005u\u0002\u0005CA\u000b?\u0013\tydC\u0001\u0003M_:<\u0007\"B!\u0006\u0001\u0004\u0011\u0015!B:uCR,\u0007CA\u000eD\u0013\t!ED\u0001\u0004V'R\fG/Z\u0001\bk:\u0004\u0018M]:f)\t9%\n\u0005\u0002\u0016\u0011&\u0011\u0011J\u0006\u0002\u0005+:LG\u000fC\u0003B\r\u0001\u0007!\t")
public abstract class HexBinaryUnparserBase
implements PrimUnparser {
    private Vector<Nothing$> runtimeDependencies;
    private final ElementRuntimeData context;
    private boolean isInitialized;
    private String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_;
    private volatile byte bitmap$0;

    public Vector<Processor> childProcessors() {
        return PrimProcessor.childProcessors$((PrimProcessor)this);
    }

    public boolean isPrimitive() {
        return PrimProcessor.isPrimitive$((PrimProcessor)this);
    }

    public boolean isEmpty() {
        return Unparser.isEmpty$((Unparser)this);
    }

    public final void unparse1(UState ustate, Object ignore) {
        Unparser.unparse1$((Unparser)this, (UState)ustate, (Object)ignore);
    }

    public final Object unparse1$default$2() {
        return Unparser.unparse1$default$2$((Unparser)this);
    }

    public Nothing$ UE(UState ustate, String s, Seq<Object> args) {
        return Unparser.UE$((Unparser)this, (UState)ustate, (String)s, args);
    }

    public String nom() {
        return ToBriefXMLImpl.nom$((ToBriefXMLImpl)this);
    }

    public String briefXMLAttributes() {
        return ToBriefXMLImpl.briefXMLAttributes$((ToBriefXMLImpl)this);
    }

    public String toBriefXML(int depthLimit) {
        return ToBriefXMLImpl.toBriefXML$((ToBriefXMLImpl)this, (int)depthLimit);
    }

    public int toBriefXML$default$1() {
        return ToBriefXMLImpl.toBriefXML$default$1$((ToBriefXMLImpl)this);
    }

    public String toString() {
        return ToBriefXMLImpl.toString$((ToBriefXMLImpl)this);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    private String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzycompute() {
        HexBinaryUnparserBase hexBinaryUnparserBase = this;
        synchronized (hexBinaryUnparserBase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_ = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$((ToBriefXMLImpl)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_;
    }

    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzycompute();
        }
        return this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_;
    }

    public ElementRuntimeData context() {
        return this.context;
    }

    private Vector<Nothing$> runtimeDependencies$lzycompute() {
        HexBinaryUnparserBase hexBinaryUnparserBase = this;
        synchronized (hexBinaryUnparserBase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.runtimeDependencies = (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.runtimeDependencies;
    }

    public Vector<Nothing$> runtimeDependencies() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.runtimeDependencies$lzycompute();
        }
        return this.runtimeDependencies;
    }

    public abstract long getLengthInBits(UState var1);

    public void unparse(UState state) {
        boolean ret;
        long l;
        DISimple node = state.currentInfosetNode().asSimple();
        byte[] value = DataValue$.MODULE$.getByteArray$extension(node.dataValue());
        long valueLengthInBytes = value.length;
        if (valueLengthInBytes > (long)state.tunable().maxHexBinaryLengthInBytes()) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Length of xs:hexBinary exceeds maximum of %s bytes: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)state.tunable().maxHexBinaryLengthInBytes()), BoxesRunTime.boxToLong((long)valueLengthInBytes)}));
        }
        long lengthInBits = this.getLengthInBits(state);
        long lengthInBytes = (lengthInBits + 7L) / 8L;
        if (valueLengthInBytes > lengthInBytes) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Length of xs:hexBinary exceeds calculated length of %s bits: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(valueLengthInBytes * 8L)), BoxesRunTime.boxToLong((long)lengthInBits)}));
        }
        if (lengthInBytes > valueLengthInBytes) {
            l = valueLengthInBytes * 8L;
        } else {
            if (lengthInBytes != valueLengthInBytes) {
                throw Assert$.MODULE$.abort("Invariant broken: lengthInBytes.==(valueLengthInBytes)");
            }
            l = lengthInBits;
        }
        long bitsFromValueToPut = l;
        DirectOrBufferedDataOutputStream dos = state.dataOutputStream();
        if (bitsFromValueToPut > 0L && !(ret = dos.putByteArray(value, bitsFromValueToPut, (FormatInfo)state, dos.putByteArray$default$4()))) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Failed to write %d hexBinary bits", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)bitsFromValueToPut)}));
        }
        long nFillBits = lengthInBits - bitsFromValueToPut;
        if (nFillBits > 0L) {
            boolean ret2 = dos.skip(nFillBits, (FormatInfo)state);
            if (!ret2) {
                throw UnparseError$.MODULE$.apply(Maybe$.MODULE$.Nope(), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Failed to skip %d bits.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)nFillBits)}));
            }
            return;
        }
    }

    public HexBinaryUnparserBase(ElementRuntimeData context) {
        this.context = context;
        ToBriefXMLImpl.$init$((ToBriefXMLImpl)this);
        Processor.$init$((Processor)this);
        Unparser.$init$((Unparser)this);
        PrimProcessor.$init$((PrimProcessor)this);
    }
}

