/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.sse;

import java.util.concurrent.Phaser;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.systest.jaxrs.sse.Book;
import org.apache.cxf.systest.jaxrs.sse.BookBroadcasterStats;
import org.apache.cxf.systest.jaxrs.sse.BookStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BookStoreClientCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BookStore.class);
    private final BookBroadcasterStats stats = new BookBroadcasterStats();
    private final Phaser phaser = new Phaser(2);

    BookStoreClientCloseable() {
    }

    protected abstract Sse getSse();

    @GET
    @Path(value="client-closes-connection/sse/{id}")
    @Produces(value={"text/event-stream"})
    public void clientCloseConnection(@Context SseEventSink sink, @PathParam(value="id") String idIgnore, @HeaderParam(value="Last-Event-ID") @DefaultValue(value="0") String lastEventId) {
        this.stats.reset();
        new Thread(() -> {
            try {
                Integer id = Integer.valueOf(lastEventId);
                OutboundSseEvent.Builder builder = this.getSse().newEventBuilder();
                SseBroadcaster localBroadcaster = this.getSse().newBroadcaster();
                localBroadcaster.onError((sseEventSink, throwable) -> this.stats.errored());
                localBroadcaster.onClose(sseEventSink -> this.stats.closed());
                localBroadcaster.register(sink);
                localBroadcaster.broadcast(BookStoreClientCloseable.createEvent(builder.name("book"), id + 1)).whenComplete((r, ex) -> this.stats.inc());
                this.phaser.arriveAndAwaitAdvance();
                Thread.sleep(500L);
                localBroadcaster.broadcast(BookStoreClientCloseable.createEvent(builder.name("book"), id + 2)).whenComplete((r, ex) -> {
                    if (ex == null && !sink.isClosed()) {
                        this.stats.inc();
                    }
                });
                this.phaser.arriveAndAwaitAdvance();
                Thread.sleep(500L);
                localBroadcaster.broadcast(BookStoreClientCloseable.createEvent(builder.name("book"), id + 3)).whenComplete((r, ex) -> {
                    if (ex == null && !sink.isClosed()) {
                        this.stats.inc();
                    }
                });
                Thread.sleep(500L);
                localBroadcaster.broadcast(BookStoreClientCloseable.createEvent(builder.name("book"), id + 4)).whenComplete((r, ex) -> {
                    if (ex != null || !sink.isClosed()) {
                        this.stats.inc();
                    }
                });
                this.stats.setWasClosed(sink.isClosed());
                this.phaser.arriveAndDeregister();
                sink.close();
            }
            catch (InterruptedException ex2) {
                LOG.error("Communication error", (Throwable)ex2);
            }
        }).start();
    }

    @PUT
    @Path(value="client-closes-connection/received")
    @Produces(value={"application/json"})
    public void received() {
        this.phaser.arriveAndAwaitAdvance();
    }

    @PUT
    @Path(value="client-closes-connection/closed")
    @Produces(value={"application/json"})
    public void closed() {
        this.phaser.arriveAndDeregister();
    }

    @GET
    @Path(value="client-closes-connection/stats")
    @Produces(value={"application/json"})
    public BookBroadcasterStats stats() {
        return this.stats;
    }

    protected static OutboundSseEvent createEvent(OutboundSseEvent.Builder builder, int eventId) {
        return builder.id(Integer.toString(eventId)).data(Book.class, (Object)new Book("New Book #" + eventId, eventId)).mediaType(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected static OutboundSseEvent createRawEvent(OutboundSseEvent.Builder builder, int eventId) {
        return builder.id(Integer.toString(eventId)).data((Object)("New Book #" + eventId)).mediaType(MediaType.TEXT_PLAIN_TYPE).build();
    }
}

