/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.sse;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.systest.jaxrs.sse.Book;
import org.apache.cxf.systest.jaxrs.sse.BookStoreClientCloseable;
import org.apache.cxf.systest.jaxrs.sse.BookStoreResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/bookstore")
public class BookStore2
extends BookStoreClientCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BookStore2.class);
    private final CountDownLatch latch = new CountDownLatch(2);
    private Sse sse;
    private SseBroadcaster broadcaster;

    public BookStore2(@Context Sse sse) {
        this.sse = sse;
        this.broadcaster = sse.newBroadcaster();
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<Book> books() {
        return Arrays.asList(new Book("New Book #1", 1), new Book("New Book #2", 2));
    }

    @GET
    @Path(value="sse/{id}")
    @Produces(value={"text/event-stream"})
    public void forBook(final @Context SseEventSink sink, @PathParam(value="id") String id, final @HeaderParam(value="Last-Event-ID") @DefaultValue(value="0") String lastEventId) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Integer id = Integer.valueOf(lastEventId);
                    OutboundSseEvent.Builder builder = BookStore2.this.sse.newEventBuilder();
                    sink.send(BookStoreClientCloseable.createEvent(builder.name("book"), id + 1));
                    Thread.sleep(200L);
                    sink.send(BookStoreClientCloseable.createEvent(builder.name("book"), id + 2));
                    Thread.sleep(200L);
                    sink.send(BookStoreClientCloseable.createEvent(builder.name("book"), id + 3));
                    Thread.sleep(200L);
                    sink.send(BookStoreClientCloseable.createEvent(builder.name("book"), id + 4));
                    Thread.sleep(200L);
                    sink.close();
                }
                catch (InterruptedException ex) {
                    LOG.error("Communication error", (Throwable)ex);
                }
            }
        }.start();
    }

    @POST
    @Path(value="sse/{id}")
    @Produces(value={"text/event-stream"})
    @Consumes(value={"text/plain"})
    public void forBookPOST(final @Context SseEventSink sink, @PathParam(value="id") String id, final String lastEventId) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Integer id = Integer.valueOf(lastEventId);
                    OutboundSseEvent.Builder builder = BookStore2.this.sse.newEventBuilder();
                    sink.send(BookStoreClientCloseable.createEvent(builder.name("book"), id + 1));
                    Thread.sleep(200L);
                    sink.send(BookStoreClientCloseable.createEvent(builder.name("book"), id + 2));
                    Thread.sleep(200L);
                    sink.send(BookStoreClientCloseable.createEvent(builder.name("book"), id + 3));
                    Thread.sleep(200L);
                    sink.send(BookStoreClientCloseable.createEvent(builder.name("book"), id + 4));
                    Thread.sleep(200L);
                    sink.close();
                }
                catch (InterruptedException ex) {
                    LOG.error("Communication error", (Throwable)ex);
                }
            }
        }.start();
    }

    @GET
    @Path(value="nodelay/sse/{id}")
    @Produces(value={"text/event-stream"})
    public void forBookNoDelay(@Context SseEventSink sink, @PathParam(value="id") String id) {
        OutboundSseEvent.Builder builder = this.sse.newEventBuilder();
        CompletableFuture.runAsync(() -> {
            sink.send(BookStore2.createEvent(builder.name("book"), 1));
            sink.send(BookStore2.createEvent(builder.name("book"), 2));
            sink.send(BookStore2.createEvent(builder.name("book"), 3));
            sink.send(BookStore2.createEvent(builder.name("book"), 4));
            sink.send(BookStore2.createEvent(builder.name("book"), 5));
        }).whenComplete((r, ex) -> sink.close());
    }

    @GET
    @Path(value="/titles/sse")
    @Produces(value={"text/event-stream"})
    public void forBookTitlesOnly(@Context SseEventSink sink) {
        OutboundSseEvent.Builder builder = this.sse.newEventBuilder();
        CompletableFuture.runAsync(() -> {
            sink.send(BookStore2.createRawEvent(builder.name("book"), 1));
            sink.send(BookStore2.createRawEvent(builder.name("book"), 2));
            sink.send(BookStore2.createRawEvent(builder.name("book"), 3));
            sink.send(BookStore2.createRawEvent(builder.name("book"), 4));
            sink.send(BookStore2.createRawEvent(builder.name("book"), 5));
        }).whenComplete((r, ex) -> sink.close());
    }

    @GET
    @Path(value="broadcast/sse")
    @Produces(value={"text/event-stream"})
    public void broadcast(@Context SseEventSink sink) {
        try {
            this.broadcaster.register(sink);
        }
        finally {
            this.latch.countDown();
        }
    }

    @GET
    @Path(value="nodata")
    @Produces(value={"text/event-stream"})
    public void nodata(@Context SseEventSink sink) {
        sink.close();
    }

    @POST
    @Path(value="broadcast/close")
    public void stop() {
        try {
            if (!this.latch.await(10L, TimeUnit.SECONDS)) {
                LOG.warn("Not enough clients have been connected, closing broadcaster anyway");
            }
            OutboundSseEvent.Builder builder = this.sse.newEventBuilder();
            this.broadcaster.broadcast(BookStore2.createEvent(builder.name("book"), 1000)).thenAcceptBoth(this.broadcaster.broadcast(BookStore2.createEvent(builder.name("book"), 2000)), (a, b) -> {}).whenComplete((r, ex) -> {
                if (this.broadcaster != null) {
                    this.broadcaster.close();
                }
            });
        }
        catch (InterruptedException ex2) {
            LOG.error("Wait has been interrupted", (Throwable)ex2);
        }
    }

    @GET
    @Path(value="/filtered/sse")
    @Produces(value={"text/event-stream"})
    public void filtered(final @Context SseEventSink sink) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    sink.close();
                }
                catch (InterruptedException ex) {
                    LOG.error("Communication error", (Throwable)ex);
                }
            }
        }.start();
    }

    @GET
    @Path(value="/filtered/stats")
    @Produces(value={"text/plain"})
    public int filteredStats() {
        return BookStoreResponseFilter.getInvocations();
    }

    @PUT
    @Path(value="/filtered/stats")
    public void clearStats() {
        BookStoreResponseFilter.reset();
    }

    @Override
    protected Sse getSse() {
        return this.sse;
    }
}

