/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.sse;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.InboundSseEvent;
import javax.ws.rs.sse.SseEventSource;
import org.apache.cxf.systest.jaxrs.sse.AbstractSseBaseTest;
import org.apache.cxf.systest.jaxrs.sse.Book;
import org.apache.cxf.systest.jaxrs.sse.BookBroadcasterStats;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractSseTest
extends AbstractSseBaseTest {
    @Before
    public void setUp() {
        MatcherAssert.assertThat((Object)this.createWebTarget("/rest/api/bookstore/filtered/stats").request().put(null).getStatus(), (Matcher)CoreMatchers.equalTo((Object)204));
    }

    @Test
    public void testBooksStreamIsReturnedFromLastEventId() throws InterruptedException {
        WebTarget target = (WebTarget)this.createWebTarget("/rest/api/bookstore/sse/" + UUID.randomUUID()).property("Last-Event-ID", (Object)150);
        ArrayList<Book> books = new ArrayList<Book>();
        try (SseEventSource eventSource = SseEventSource.target((WebTarget)target).build();){
            eventSource.register(AbstractSseTest.collect(books), System.out::println);
            eventSource.open();
            this.awaitEvents(5000, books, 4);
        }
        MatcherAssert.assertThat(books, (Matcher)CoreMatchers.hasItems((Object[])new Book[]{new Book("New Book #151", 151), new Book("New Book #152", 152), new Book("New Book #153", 153), new Book("New Book #154", 154)}));
    }

    @Test
    public void testBooksStreamIsReturnedFromInboundSseEvents() throws InterruptedException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/sse/0");
        ArrayList<Book> books = new ArrayList<Book>();
        try (SseEventSource eventSource = SseEventSource.target((WebTarget)target).build();){
            eventSource.register(AbstractSseTest.collect(books), System.out::println);
            eventSource.open();
            this.awaitEvents(5000, books, 4);
        }
        MatcherAssert.assertThat(books, (Matcher)CoreMatchers.hasItems((Object[])new Book[]{new Book("New Book #1", 1), new Book("New Book #2", 2), new Book("New Book #3", 3), new Book("New Book #4", 4)}));
    }

    @Test
    public void testBooksStreamIsReturnedFromInboundSseEventsWithPOST() throws InterruptedException, IOException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/sse/0");
        ArrayList<Book> books = new ArrayList<Book>();
        JacksonJsonProvider mbr = new JacksonJsonProvider();
        Response response = target.request(new String[]{"text/event-stream"}).post(Entity.entity((Object)42, (String)"text/plain"));
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)response.readEntity(InputStream.class)));){
            String s;
            Integer id = null;
            Book book = null;
            while ((s = br.readLine()) != null) {
                if (s.trim().isEmpty()) {
                    if (id == null && book == null) continue;
                    if (id != null && book != null) {
                        books.add(book);
                        id = null;
                        book = null;
                        continue;
                    }
                    Assert.fail((String)("The event did not contain both an id " + id + " and a book " + book));
                }
                if (s.startsWith("event:")) {
                    Assert.assertEquals((String)"Not a book event", (Object)"event: book", (Object)s.trim());
                    continue;
                }
                if (s.startsWith("id:")) {
                    Assert.assertNull((String)("There was an existing id " + id), id);
                    id = Integer.parseInt(s.substring(3).trim());
                    continue;
                }
                if (s.startsWith("data:")) {
                    Assert.assertNull((String)("There was an existing book " + book), book);
                    book = (Book)mbr.readFrom(Book.class, Book.class, null, MediaType.APPLICATION_JSON_TYPE, null, (InputStream)new ByteArrayInputStream(s.substring(5).trim().getBytes(StandardCharsets.UTF_8)));
                    continue;
                }
                Assert.fail((String)("Unexpected String content returned by SSE POST " + s));
            }
        }
        MatcherAssert.assertThat(books, (Matcher)CoreMatchers.hasItems((Object[])new Book[]{new Book("New Book #43", 43), new Book("New Book #44", 44), new Book("New Book #45", 45), new Book("New Book #46", 46)}));
    }

    @Test
    public void testBookTitlesStreamIsReturnedFromInboundSseEvents() throws InterruptedException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/titles/sse");
        ArrayList<String> titles = new ArrayList<String>();
        try (SseEventSource eventSource = SseEventSource.target((WebTarget)target).build();){
            eventSource.register(AbstractSseTest.collectRaw(titles), System.out::println);
            eventSource.open();
            this.awaitEvents(5000, titles, 4);
        }
        MatcherAssert.assertThat(titles, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"New Book #1", "New Book #2", "New Book #3", "New Book #4"}));
    }

    @Test
    public void testNoDataIsReturnedFromInboundSseEvents() throws InterruptedException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/nodata");
        ArrayList<Book> books = new ArrayList<Book>();
        try (SseEventSource eventSource = SseEventSource.target((WebTarget)target).build();){
            eventSource.register(AbstractSseTest.collect(books), System.out::println);
            eventSource.open();
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)books.isEmpty());
    }

    @Test
    public void testBooksSseContainerResponseFilterIsCalled() throws InterruptedException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/filtered/sse");
        ArrayList<Book> books = new ArrayList<Book>();
        MatcherAssert.assertThat((Object)this.createWebTarget("/rest/api/bookstore/filtered/stats").request().get(Integer.class), (Matcher)CoreMatchers.equalTo((Object)0));
        try (SseEventSource eventSource = SseEventSource.target((WebTarget)target).build();){
            eventSource.register(AbstractSseTest.collect(books), System.out::println);
            eventSource.open();
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)books.isEmpty());
        MatcherAssert.assertThat((Object)this.createWebTarget("/rest/api/bookstore/filtered/stats").request().get(Integer.class), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testBooksStreamIsReconnectedFromInboundSseEvents() throws InterruptedException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/sse/0");
        ArrayList<Book> books = new ArrayList<Book>();
        SseEventSource.Builder builder = SseEventSource.target((WebTarget)target).reconnectingEvery(1L, TimeUnit.SECONDS);
        try (SseEventSource eventSource = builder.build();){
            eventSource.register(AbstractSseTest.collect(books), System.out::println);
            eventSource.open();
            this.awaitEvents(5000, books, 12);
        }
        MatcherAssert.assertThat(books, (Matcher)CoreMatchers.hasItems((Object[])new Book[]{new Book("New Book #1", 1), new Book("New Book #2", 2), new Book("New Book #3", 3), new Book("New Book #4", 4), new Book("New Book #5", 5), new Book("New Book #6", 6), new Book("New Book #7", 7), new Book("New Book #8", 8), new Book("New Book #9", 9), new Book("New Book #10", 10), new Book("New Book #11", 11), new Book("New Book #12", 12)}));
    }

    @Test
    public void testBooksStreamIsBroadcasted() throws Exception {
        ArrayList<Future> results = new ArrayList<Future>();
        for (int i = 0; i < 2; ++i) {
            results.add(this.createWebClient("/rest/api/bookstore/broadcast/sse").async().get());
        }
        ((Response)this.createWebClient("/rest/api/bookstore/broadcast/close").async().post(null).get(10L, TimeUnit.SECONDS)).close();
        for (Future result : results) {
            Response r = (Response)result.get(3L, TimeUnit.SECONDS);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            String response = (String)r.readEntity(String.class);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"id: 1000"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)("data: " + this.toJson("New Book #1000", 1000))));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"id: 2000"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)("data: " + this.toJson("New Book #2000", 2000))));
            r.close();
        }
    }

    @Test
    public void testBooksAreReturned() throws JsonProcessingException {
        Response r = this.createWebClient("/rest/api/bookstore", "application/json").get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Book[] books = (Book[])r.readEntity(Book[].class);
        MatcherAssert.assertThat(Arrays.asList(books), (Matcher)CoreMatchers.hasItems((Object[])new Book[]{new Book("New Book #1", 1), new Book("New Book #2", 2)}));
        r.close();
    }

    @Test
    public void testBooksContainerResponseFilterIsCalled() throws InterruptedException {
        Response r = this.createWebClient("/rest/api/bookstore", "application/json").get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        MatcherAssert.assertThat((Object)this.createWebTarget("/rest/api/bookstore/filtered/stats").request().get(Integer.class), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testBooksStreamIsReturnedFromInboundSseEventsNoDelay() throws InterruptedException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/nodelay/sse/0");
        ArrayList<Book> books = new ArrayList<Book>();
        try (SseEventSource eventSource = SseEventSource.target((WebTarget)target).build();){
            eventSource.register(AbstractSseTest.collect(books), System.out::println);
            eventSource.open();
            this.awaitEvents(5000, books, 5);
        }
        MatcherAssert.assertThat(books, (Matcher)CoreMatchers.hasItems((Object[])new Book[]{new Book("New Book #1", 1), new Book("New Book #2", 2), new Book("New Book #3", 3), new Book("New Book #4", 4), new Book("New Book #5", 5)}));
    }

    @Test
    public void testClientClosesEventSource() throws InterruptedException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/client-closes-connection/sse/0");
        ArrayList<Book> books = new ArrayList<Book>();
        try (SseEventSource eventSource = SseEventSource.target((WebTarget)target).build();){
            eventSource.register(AbstractSseTest.collect(books), System.out::println);
            eventSource.open();
            this.awaitEvents(200, books, 1);
            Response r = this.createWebClient("/rest/api/bookstore/client-closes-connection/received", "application/json").put(null);
            MatcherAssert.assertThat((Object)r.getStatus(), (Matcher)CoreMatchers.equalTo((Object)204));
            MatcherAssert.assertThat((Object)eventSource.close(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.equalTo((Object)true));
        }
        MatcherAssert.assertThat(books, (Matcher)CoreMatchers.hasItems((Object[])new Book[]{new Book("New Book #1", 1)}));
        Response r = this.createWebClient("/rest/api/bookstore/client-closes-connection/closed", "application/json").put(null);
        MatcherAssert.assertThat((Object)r.getStatus(), (Matcher)CoreMatchers.equalTo((Object)204));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            BookBroadcasterStats stats = (BookBroadcasterStats)this.createWebClient("/rest/api/bookstore/client-closes-connection/stats", "application/json").get().readEntity(BookBroadcasterStats.class);
            MatcherAssert.assertThat((Object)stats.isErrored(), (Matcher)CoreMatchers.equalTo((Object)this.supportsErrorPropagation()));
            MatcherAssert.assertThat((Object)stats.isWasClosed(), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)stats.isClosed(), (Matcher)CoreMatchers.equalTo((Object)true));
            Assert.assertTrue((stats.getCompleted() <= 3 ? 1 : 0) != 0);
        });
    }

    @Test
    public void testBooksSseContainerResponseAddedHeaders() throws InterruptedException {
        WebTarget target = this.createWebTarget("/rest/api/bookstore/headers/sse");
        try (Response response = target.request(new String[]{"text/event-stream"}).get();){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.equalTo((Object)202));
            MatcherAssert.assertThat((Object)response.getHeaderString("X-My-Header"), (Matcher)CoreMatchers.equalTo((Object)"headers"));
            MatcherAssert.assertThat((Object)response.getHeaderString("X-My-ProtocolHeader"), (Matcher)CoreMatchers.equalTo((Object)"protocol-headers"));
        }
    }

    protected boolean supportsErrorPropagation() {
        return false;
    }

    private static Consumer<InboundSseEvent> collect(Collection<Book> books) {
        return event -> books.add((Book)event.readData(Book.class, MediaType.APPLICATION_JSON_TYPE));
    }

    private static Consumer<InboundSseEvent> collectRaw(Collection<String> titles) {
        return event -> titles.add((String)event.readData(String.class, MediaType.TEXT_PLAIN_TYPE));
    }
}

