/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.kerberos.jaxrs.kerberos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.security.KerberosAuthOutInterceptor;
import org.apache.cxf.systest.kerberos.common.SecurityTestUtil;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.Book;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.BookKerberosServer;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.BookStore;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.cxf.transport.http.auth.SpnegoAuthSupplier;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.ietf.jgss.GSSName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="AbstractKerberosTest-class", enableAccessControl=false, allowAnonAccess=false, enableChangeLog=true, partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})}, additionalInterceptors={KeyDerivationInterceptor.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@CreateKdcServer(transports={@CreateTransport(protocol="UDP", address="127.0.0.1")}, primaryRealm="service.ws.apache.org", kdcPrincipal="krbtgt/service.ws.apache.org@service.ws.apache.org")
@ApplyLdifFiles(value={"kerberos.ldif"})
public class JAXRSKerberosBookTest
extends AbstractLdapTestUnit {
    public static final String PORT = BookKerberosServer.PORT;
    private static final String KERBEROS_CONFIG_FILE = "org/apache/cxf/systest/kerberos/jaxrs/kerberos/kerberosClient.xml";
    private static boolean runTests;
    private static boolean portUpdated;

    @Before
    public void updatePort() throws Exception {
        if (!portUpdated) {
            String basedir = System.getProperty("basedir");
            if (basedir == null) {
                basedir = new File(".").getCanonicalPath();
            }
            File f = new File(basedir + "/src/test/resources/krb5.conf");
            FileInputStream inputStream = new FileInputStream(f);
            String content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
            content = content.replaceAll("port", "" + AbstractLdapTestUnit.getKdcServer().getTransports()[0].getPort());
            File f2 = new File(basedir + "/target/test-classes/jaxrs.krb5.conf");
            FileOutputStream outputStream = new FileOutputStream(f2);
            IOUtils.write((String)content, (OutputStream)outputStream, (String)"UTF-8");
            outputStream.close();
            System.setProperty("java.security.krb5.conf", f2.getPath());
            portUpdated = true;
        }
    }

    @BeforeClass
    public static void startServers() throws Exception {
        if (!"IBM Corporation".equals(System.getProperty("java.vendor"))) {
            runTests = true;
            String basedir = System.getProperty("basedir");
            basedir = basedir == null ? new File(".").getCanonicalPath() : basedir + "/..";
            System.setProperty("java.security.auth.login.config", basedir + "/kerberos/src/test/resources/kerberos.jaas");
        }
        Assert.assertTrue((String)"Server failed to launch", (boolean)AbstractBusClientServerTestBase.launchServer(BookKerberosServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        AbstractBusClientServerTestBase.stopAllServers();
    }

    @Test
    public void testGetBookWithConfigInHttpConduit() throws Exception {
        if (!runTests) {
            return;
        }
        this.doTestGetBook123Proxy(KERBEROS_CONFIG_FILE);
    }

    private void doTestGetBook123Proxy(String configFile) throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, (String)configFile);
        WebClient.getConfig((Object)bs).getOutInterceptors().add(new LoggingOutInterceptor());
        SpnegoAuthSupplier authSupplier = new SpnegoAuthSupplier();
        authSupplier.setServicePrincipalName("bob@service.ws.apache.org");
        authSupplier.setServiceNameType(GSSName.NT_HOSTBASED_SERVICE);
        WebClient.getConfig((Object)bs).getHttpConduit().setAuthSupplier((HttpAuthSupplier)authSupplier);
        Assert.assertEquals((Object)("http://localhost:" + PORT), (Object)WebClient.client((Object)bs).getBaseURI().toString());
        Book b = bs.getBook("123");
        Assert.assertEquals((long)b.getId(), (long)123L);
        b = bs.getBook("123");
        Assert.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetBookWithInterceptor() throws Exception {
        if (!runTests) {
            return;
        }
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/123"));
        KerberosAuthOutInterceptor kbInterceptor = new KerberosAuthOutInterceptor();
        AuthorizationPolicy policy = new AuthorizationPolicy();
        policy.setAuthorizationType("Negotiate");
        policy.setAuthorization("alice");
        policy.setUserName("alice");
        policy.setPassword("alice");
        kbInterceptor.setPolicy(policy);
        kbInterceptor.setCredDelegation(true);
        WebClient.getConfig((Object)wc).getOutInterceptors().add(new LoggingOutInterceptor());
        WebClient.getConfig((Object)wc).getOutInterceptors().add(kbInterceptor);
        kbInterceptor.setServicePrincipalName("bob@service.ws.apache.org");
        kbInterceptor.setServiceNameType(GSSName.NT_HOSTBASED_SERVICE);
        Book b = (Book)wc.get(Book.class);
        Assert.assertEquals((long)b.getId(), (long)123L);
    }
}

